% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-obfuscation.R
\docType{data}
\name{obfuscation}
\alias{obfuscation}
\title{Obfuscated C code misinterpretation data}
\format{A data frame with 57 rows and 4 variables:
\describe{
  \item{subject}{the ID of the study participant}
  \item{atom}{the type of obfuscation being evaluated}
  \item{control}{whether the subject answered the un-obfuscated question correctly}
  \item{treatment}{whether the subject answered the obfuscated question correctly}
}}
\source{
\href{http://atomsofconfusion.com}{Atoms of Confusion}
}
\usage{
data(obfuscation)
}
\description{
Data from Gopstein et. al.'s experiment on the misinterpretation of C code.
Subjects were asked to hand evaluate pairs of functionally equivalent code.
Half of the questions were intentionally obfuscated to elicit confusion.
}
\examples{
data(obfuscation)

oc <- paired.to.contingency(group = obfuscation[,c("subject", "atom")],
                            t1    = obfuscation$control,
                            t2    = obfuscation$treatment)

clust.bin.pair(oc$ak, oc$bk, oc$ck, oc$dk, method="durkalski")
}
\keyword{datasets}

