% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred-data.R
\docType{data}
\name{preddata.std}
\alias{preddata.std}
\title{Prediction Data - Concrete Slump Test}
\format{
A data frame with 103 rows and 8 variables.
}
\source{
https://archive.ics.uci.edu/ml/datasets/Concrete+Compressive+Strength
}
\usage{
data(preddata.std)
}
\description{
Pre-processed and standardized Concrete Slump Test is a
real-life data set from
University of California at Irvine (UCI) machine learning data
repository UCI: Machine Learning Repository
(available at http://archive.ics.uci.edu/ml/).
}
\examples{
\dontrun{
data(preddata.std)
cmaRs(Compressive_Strength ~ ., classification = FALSE, data = preddata.std)
}
}
\references{
Yeh, I.-C. (2007).
Modeling slump flow of concrete using second-order regressions
and artificial neural networks.
Cement and Concrete Composites, 29(6): 474 - 480.
}
\keyword{datasets}
