% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmps_plot.R
\name{cmps_segment_plot}
\alias{cmps_segment_plot}
\title{Plot the selected basis segment and its cross-correlation curve at all scales based on the
results of CMPS algorithm}
\usage{
cmps_segment_plot(cmps_result, seg_idx = 1)
}
\arguments{
\item{cmps_result}{a list generated by \code{extract_feature_cmps}. \code{cmps_result} is required to have
the following names: \code{parameters}, \code{congruent_pos}, \code{segments}, \code{nseg}, i.e. one should at least have
\code{include = c("parameters", "congruent_pos", "segments", "nseg")} when computing \code{cmps_result}.
However, \verb{include = "full_result} is still recommended.}

\item{seg_idx}{an integer. The index of a basis segment that we want to plot for.}
}
\value{
a list of n elements, where n is the length of \code{npeaks_set}, i.e. the number of scales for
each basis segment. And each one of these n elements is also a list, a list of two plots:
\itemize{
\item \code{segment_plot}: The basis segment of current scale is plotted at different positions where the
segment obtains correlation peak. The comparison signature is also plotted.
\item \code{scale_ccf_plot}: This is the plot of the cross-correlation curve between the comparison signature
and the segment of the current scale.
}
}
\description{
This function plots the selected basis segment with the comparison signature. One can visualize the
scaled segment and its corresponding cross-correlation curve. The number of marked correlation peaks
at each segment scale is determined by \code{npeaks_set} of \code{extract_feature_cmps}. The red vertical dashed
line indicates the congruent registration position for all segments; the green vertical dashed line
indicates the position of the consistent correlation peak (if any); the blue vertical dashed line
indicates the tolerance zone (determined by \code{Tx})
}
\examples{
library(cmpsR)
library(ggpubr)

data("bullets")
land2_3 <- bullets$sigs[bullets$bulletland == "2-3"][[1]]
land1_2 <- bullets$sigs[bullets$bulletland == "1-2"][[1]]

# compute cmps

# algorithm with multi-peak insepction at three different segment scales
cmps_with_multi_scale <- extract_feature_cmps(land2_3$sig, land1_2$sig, include = "full_result" )

# generate plots using cmps_signature_plot
seg_plot <- cmps_segment_plot(cmps_with_multi_scale, seg_idx = 3)

pp <- ggarrange(plotlist = unlist(seg_plot, recursive = FALSE), nrow = 3, ncol = 2)

}
