% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_avetrteff2.R
\name{avetrteff2}
\alias{avetrteff2}
\title{Compute the average subpopulation treatment effect and the standardized average subpopulation treatment effect when two biomarkers are involved}
\usage{
avetrteff2(z1z2, kappa, rhovec, sigma, muminusmu0)
}
\arguments{
\item{z1z2}{a numeric vector of two numbers that are standardized biomarker values}

\item{kappa}{a number of the correlation coefficient between two biomarkers}

\item{rhovec}{a numeric vector of two correlation coefficients between the output and two biomarkers}

\item{sigma}{a number of the standard deviation of outcome}

\item{muminusmu0}{a number of the difference between the mean of outcome and the minimal clinically important treatment effect}
}
\value{
a list of three numbers: \code{delta} is the average subpopulation treatment effect, \code{lambda} is the standardized average subpopulation treatment effect, and \code{cVar} is the variance with respect to the truncated distribution with specified cutoff values
}
\description{
Compute the average subpopulation treatment effect and the standardized average subpopulation treatment effect when two biomarkers are involved
}
\examples{
x1x2 <- c(2, 1)
nu1nu2 <- c(0,0)
tau1tau2 <- c(1,1)
z1z2 <- (x1x2 - nu1nu2)/tau1tau2
muminusmu0 <- 1.8
kappa <- 0.1
sigma <- 1
rhovec <- c(0.1, 0.2)
avetrteff2(z1z2, kappa, rhovec, sigma, muminusmu0)
}
\references{
Zhang, F. and Gou, J. (2025). Using multiple biomarkers for patient enrichment in two-stage clinical designs. Technical Report.
}
\author{
Jiangtao Gou
}
