% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_stats_lm.R
\name{format_stats.lm}
\alias{format_stats.lm}
\title{Format linear model statistics}
\usage{
\method{format_stats}{lm}(
  x,
  term = NULL,
  digits = 3,
  pdigits = 3,
  pzero = FALSE,
  full = TRUE,
  italics = TRUE,
  dfs = "par",
  type = "md",
  ...
)
}
\arguments{
\item{x}{An \code{lm} or \code{glm} object from \code{\link[stats:lm]{stats::lm()}} or \code{\link[stats:glm]{stats::glm()}}.}

\item{term}{Character string for row name of term to extract statistics for.
This must be the exact string returned in the \code{summary()} output from the
\code{lm} or \code{glm} object.}

\item{digits}{Number of digits after the decimal for test statistics.}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values).}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values.}

\item{full}{Logical value (default = TRUE) for whether to include extra
info (e.g., standard errors and t-values or z-values for terms)
or just test statistic and p-value.}

\item{italics}{Logical value (default = TRUE) for whether statistics labels
should be italicized.}

\item{dfs}{Formatting for degrees of freedom ("par" = parenthetical,
"sub" = subscript, "none" = do not print degrees of freedom).}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
This method formats (generalized) linear model statistics from the class
\code{lm} or \code{glm}. If no term is specified, overall model statistics are
returned. For linear models (\code{lm} objects), this includes the R-squared,
F statistic, and p-value. For generalized linear models (\code{glm} objects),
this includes deviance and AIC.
The default output is APA formatted, but this function allows
control over numbers of digits, leading zeros, italics, degrees of freedom,
and output format of Markdown or LaTeX.
}
\examples{
test_lm <- lm(mpg ~ cyl * hp, data = mtcars)
test_glm <- glm(am ~ cyl * hp, data = mtcars, family = binomial)

# Format linear model overall statistics
format_stats(test_lm)

# Format linear model term statistics
format_stats(test_lm, term = "cyl")

# Format generalized linear model overall statistics
format_stats(test_glm)

# Format generalized linear model term statistics
format_stats(test_glm, term = "cyl")

# Remove italics and make degrees of freedom subscripts
format_stats(test_lm, term = "cyl", italics = FALSE, dfs = "sub")

# Change digits and add leading zero to p-value
format_stats(test_lm, term = "hp", digits = 3, pdigits = 4, pzero = TRUE)

# Format for LaTeX
format_stats(test_lm, term = "hp", type = "latex")
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_chisq}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.aov}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_stats.lmerModLmerTest}()},
\code{\link{format_stats.merMod}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
