% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_for_datasets.R
\docType{data}
\name{ae}
\alias{ae}
\alias{knee_ae}
\alias{hip_ae}
\title{Classcodes for adverse events after knee and hip arthroplasty}
\format{
Data frame with 3 columns:
\describe{
\item{group}{Different types of adverse events (see reference section)}
\item{icd10}{regular expressions identifying ICD-10 codes for each
group}
\item{icd10_fracture}{regular expressions for fracture patients.
Essentially the same as \code{regex} but with some additional codes for
group "DM1 other"}
\item{kva}{regular expressions identifying KVA codes}
\item{condition}{special conditions are used, see below.}
}

An object of class \code{classcodes} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 7 rows and 5 columns.
}
\usage{
knee_ae

hip_ae
}
\description{
ICD-10 group names are prefixed by two letters as given by the references.
Two groups (DB and DM) are split into two due to different conditions.
}
\section{Hip fractures}{

Adverse events (AE) codes for hip fractures are based on codes for elective
cases but with some additional codes for DM 1 (N300, N308, N309 and N390).
}

\section{Conditions}{

Special conditions apply to all categories.
Those require non-standard modifications
of the classcodes data prior to categorization.

\describe{
\item{hbdia1_hdia}{\code{TRUE} if the code was
given as any type of diagnose during hospital visit for index operation,
or as main diagnose for later visits, otherwise \code{FALSE}}
\item{late_hdia}{\code{TRUE} if the code was
given as main diagnose at a later visit after the index operation,
otherwise \code{FALSE}}
\item{post_op}{\code{TRUE} if the code was
given at a later visit after the index operation, otherwise \code{FALSE}}
}
}

\references{
Magneli M, Unbeck M, Rogmark C, Rolfson O, Hommel A, Samuelsson B, et al.
Validation of adverse events after hip arthroplasty:
a Swedish multi-centre cohort study.
BMJ Open. 2019 Mar 7;9(3):e023773.
}
\seealso{
hip_ae_hailer

Other default classcodes: 
\code{\link{charlson}},
\code{\link{cps}},
\code{\link{elixhauser}},
\code{\link{hip_ae_hailer}},
\code{\link{rxriskv}}
}
\concept{default classcodes}
\keyword{datasets}
