% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCoef.r
\name{extract.coef.maxLik}
\alias{extract.coef.maxLik}
\title{extract.coef.maxLik}
\usage{
\method{extract.coef}{maxLik}(model, ...)
}
\arguments{
\item{model}{Model object from which to extract information.}

\item{\dots}{Further arguments}
}
\value{
A \code{\link{data.frame}} containing the coefficient, the standard 
error and the variable name.
}
\description{
Extract Coefficient Information from Models
}
\details{
Gets the coefficient values and variable names from a model.
}
\examples{
\dontshow{
if(requireNamespace('maxLik', quietly=TRUE))
\{
}
library(maxLik)
loglik <- function(param) {
 mu <- param[1]
 sigma <- param[2]
 ll <- -0.5*N*log(2*pi) - N*log(sigma) - sum(0.5*(x - mu)^2/sigma^2)
ll
}
x <- rnorm(1000, 1, 2) # use mean=1, stdd=2
N <- length(x)
res <- maxLik(loglik, start=c(0,1)) # use 'wrong' start values
extract.coef(res)
\dontshow{
\}
}

}
\author{
Jared P. Lander
}
