% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv_omega.R
\name{deriv_omega}
\alias{deriv_omega}
\title{Derivatives and Information for Omega}
\usage{
deriv_omega(
  y = NULL,
  omega = NULL,
  gamma = NULL,
  lambda = NULL,
  zeta = NULL,
  nu = NULL,
  kappa = NULL,
  omega_mu = NULL,
  omega_sigma2 = NULL,
  zeta_mu = NULL,
  zeta_sigma2 = NULL,
  est_zeta = TRUE,
  link = NULL
)
}
\arguments{
\item{y}{Item response matrix (K by IJ).}

\item{omega}{Contrast effects matrix (K by
MN).}

\item{gamma}{Contrast codes matrix (JM by MN).}

\item{lambda}{Item slope matrix (IJ by JM).}

\item{zeta}{Specific effects matrix (K by
JM).}

\item{nu}{Item intercept matrix  (IJ by 1).}

\item{kappa}{Item guessing matrix  (IJ by 1). Defaults to 0.}

\item{omega_mu}{Mean prior for omega (1 by MN).}

\item{omega_sigma2}{Covariance prior for omega (MN by MN).}

\item{zeta_mu}{Mean prior for zeta (1 by JM).}

\item{zeta_sigma2}{Covariance prior for zeta (JM by JM).}

\item{est_zeta}{Logical indicating whether or not to estimate zeta
derivatives}

\item{link}{Choose between "logit" or "probit" link functions.}
}
\value{
List with elements fpd (1 by MN vector of first partial derivatives
for omega), spd (MN by MN matrix of second partial derivatives for omega),
post_info (MN by MN posterior information matrix for omega), and fisher_info
(MN by MN Fisher information matrix for omega). Within each of these
elements, there are sub-elements for all K examinees.
}
\description{
This function calculates the matrix of first partial derivatives, the matrix
of second partial derivatives, and matrix of posterior and Fisher information
for the posterior distribution with respect to omega (ability) based on the
slope-intercept form of the 1-, 2-, or 3-parameter item response theory
model.
}
\section{Dimensions}{

I = Number of items per condition; J = Number of conditions; K = Number of
examinees; M Number of ability (or trait) dimensions; N Number of contrasts
(should include intercept).
}

\section{A Note About Model Notation}{

The function converts GLLVM notation to the more typical IRT notation used by
Segall (1996) for ease of referencing formulas (with the exception of using
the slope-intercept form of the item response model).
}

\references{
Segall, D. O. (1996). Multidimensional adaptive testing.
\emph{Psychometrika, 61(2)}, 331-354. https://doi.org/10.1007/BF02294343

Segall, D. O. (2009). Principles of Multidimensional Adaptive Testing. In W.
J. van der Linden & C. A. W. Glas (Eds.), \emph{Elements of Adaptive Testing}
 (pp. 57-75). https://doi.org/10.1007/978-0-387-85461-8_3
}
\keyword{internal}
