% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gam_cor_to_vif}
\alias{gam_cor_to_vif}
\title{GAM describing the relationship between correlation and VIF thresholds}
\format{
A \code{\link[mgcv]{gam}} object.
}
\source{
Generated internally from \link{experiment_cor_vs_vif}.
}
\usage{
data(gam_cor_to_vif)
}
\description{
A fitted generalized additive model describing \code{max_vif} as a function of \code{max_cor} in \link{experiment_cor_vs_vif}.
}
\details{
The model parameters (basis dimension \code{k} and weight exponent) were selected via optimization, filtering for models in the top 90\\% of R-squared and bottom 10\\% of effective degrees of freedom to balance fit quality and parsimony.

The final model uses squared Jaccard similarity as weights to emphasize cases with high agreement between \code{\link[=cor_select]{cor_select()}} and \code{\link[=vif_select]{vif_select()}}.

Model performance:
\itemize{
\item Adjusted R-squared: 0.834
\item Deviance explained: 83.4\\%
\item Effective degrees of freedom for smooth: ~6
}
}
\examples{
data(gam_cor_to_vif)
plot(gam_cor_to_vif, shade = TRUE)
}
\seealso{
Other experiments: 
\code{\link{experiment_adaptive_thresholds}},
\code{\link{experiment_cor_vs_vif}},
\code{\link{prediction_cor_to_vif}}
}
\concept{experiments}
\keyword{datasets}
