% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{prediction_cor_to_vif}
\alias{prediction_cor_to_vif}
\title{Prediction of the model \code{gam_cor_to_vif} across correlation values}
\format{
A dataframe with 901 rows and 2 numeric columns:
\describe{
\item{max_cor}{Maximum allowed pairwise correlation, from 0.10 to 1.00 in steps of 0.001.}
\item{max_vif}{Predicted VIF threshold corresponding to each \code{max_cor}.}
}
}
\usage{
data(prediction_cor_to_vif)
}
\description{
Dataframe with predicted VIF threshold corresponding to a given correlation threshold..
}
\details{
Values were generated by applying \code{mgcv::predict.gam()} to the fitted model \link{gam_cor_to_vif} and rounding to three decimal places.
}
\examples{
data(prediction_cor_to_vif)
head(prediction_cor_to_vif)
plot(max_vif ~ max_cor, data = prediction_cor_to_vif, type = "l")
}
\seealso{
Other experiments: 
\code{\link{experiment_adaptive_thresholds}},
\code{\link{experiment_cor_vs_vif}},
\code{\link{gam_cor_to_vif}}
}
\concept{experiments}
\keyword{datasets}
