% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_f.R
\name{validate_arg_f}
\alias{validate_arg_f}
\title{Check and validate argument \code{f}}
\usage{
validate_arg_f(f = NULL, f_name = NULL, function_name = NULL)
}
\arguments{
\item{f}{(optional: function name) Unquoted function name without parenthesis (see \link{f_functions}). By default calls to \code{\link[=f_auto]{f_auto()}}, which selects a suitable function depending on the nature of the response and predictors. Set to NULL if \code{responses = NULL}. If NULL, predictors are ranked from lower to higher multicollinearity. Default: \code{f_auto}}

\item{f_name}{(optional, string) Name of the function \code{f}, as returned by \code{deparse(substitute(f))}. Default: NULL}

\item{function_name}{(optional, character string) Name of the function performing the argument check. Default: NULL}
}
\value{
function
}
\description{
Check and validate argument \code{f}
}
\examples{
x <- validate_arg_f(f = f_auto)
}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\concept{argument_validation}
