% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{colorwheel2d}
\alias{colorwheel2d}
\title{Map values to a 2D colorwheel legend.}
\usage{
colorwheel2d(
  data,
  colors = c("black", "yellow", "green", "cyan", "blue", "magenta", "red"),
  origin = NULL,
  xyratio = NULL,
  kernel = NULL
)
}
\arguments{
\item{data}{Matrix or data frame with 2 numeric columns; they will map to x
and y.}

\item{colors}{Vector of colors to interpolate: center followed by periphery
counterclockwise from 3 o'clock.}

\item{origin}{Coordindates of color wheel center.}

\item{xyratio}{Scalar representing how to map the elliptical color wheel in
the data space (the default 1 a circular mapping that weights the two
dimensions equally).}

\item{kernel}{Optional function describing the shape of radial color
gradients (default is a linear mapping corresponding to a triangular
kernel); this function should take a vector of distances to the center as
its sole input and return a positive number.}
}
\value{
Character vector of colors.
}
\description{
This function returns a color value for each row of the 2-column dataset
supplied, based on a 2D color palette defined by a center color and a series
of peripheral colors.
}
\examples{
plot(iris, 
      col = colorwheel2d(iris[, c("Sepal.Length", "Sepal.Width")]), 
      pch = 19, cex = 2)
      
plot(iris, 
      col = colorwheel2d(
                  iris[, c("Sepal.Length", "Sepal.Width")],
                  origin = c(5.5, 2.5),
                  kernel = function(x) x ^ .5), 
      pch = 19, cex = 2)
}
