% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat_to_combiroc.R
\name{seurat_to_combiroc}
\alias{seurat_to_combiroc}
\title{Load CombiROC data.}
\usage{
seurat_to_combiroc(
  SeuratObject,
  gene_list,
  assay = "RNA",
  labelled_data = F,
  case_class = NA,
  case_label = "case",
  control_label = "control"
)
}
\arguments{
\item{SeuratObject}{Defines S4 classes for single-cell genomic data and associated information.}

\item{gene_list}{a list of gene names.}

\item{assay}{a character that specifies the assay of interest.}

\item{labelled_data}{a boolean that specifies whether the combiroc data to be extracted must be labelled (with 'Class' column) or not.}

\item{case_class}{a character or a character vector specifying the category/ies to be considered as 'case class'. Required if labelled_data is TRUE.}

\item{case_label}{a character that will be assigned to the cells belonging to 'case class' category.}

\item{control_label}{a character that will be assigned to the cells belonging to 'control class' category.}
}
\value{
a combiroc data.
}
\description{
A function to extract a combiroc data (both labelled and unlabelled) from a SeuratObject.
}
\details{
By specifying a gene list (if the genes are in rownames of SeuratObject assay matrix, it subsets the gene expression matrix (@data) and it retreives their expression values. If a combiroc training dataset (labelled_data=T) is required, one or more categories of Idents(SeuratObject) must be selected as case_class, the others will be merged into control class.
}
\examples{
\dontrun{
demo_seurat# A subset of PBMC3K dataset from Satijia et al. 2015

# list of markers of interest
gene_list<-c('RBP7','CYP1B1','CD14','FCN1','NKG7', 'GNLY')

# to extract the combircoc data from data from pbmc3k.final (case class: Monocytes)
data <- seurat_to_combiroc(demo_seurat, gene_list = gene_list, labelled_data = TRUE,
                           case_class = c('CD14+ Mono','FCGR3A+ Mono'),
                           case_label = 'Monocyte', control_label='Other')
head(data)
}
}
