% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcATHBx.R
\name{calcATHBx}
\alias{calcATHBx}
\title{PMV based on Adaptive Thermal Heat Balance Framework for the extended Model}
\usage{
calcATHBx(trm, ta, tr, vel, rh, met, buildingTypeSimple, 
coolingStrategyBuilding, seasonSimple)
}
\arguments{
\item{trm}{- Running mean outdoor temperature in [degree C]}

\item{ta}{- a numeric value presenting air temperature in [degree C]}

\item{tr}{- a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{- a numeric value presenting air velocity in [m/s]}

\item{rh}{- a numeric value presenting relative humidity [\%]}

\item{met}{- a numeric value presenting metabolic rate in [met]}

\item{buildingTypeSimple}{- simple building type. Value can be among Multifamily housing, 
Office as a string}

\item{coolingStrategyBuilding}{- the process in which the building was 
ventilated. Value can be among Mixed Mode','Naturally Ventilated' as a String}

\item{seasonSimple}{- season. Value can be among 'Spring','Summer', 'Winter' as a String}
}
\value{
\code{calcATHBx} PMV value adapted through the ATHB approach with extended model
}
\description{
\code{calcATHBx} calculates the PMV based on adaptive thermal heat balance framework

based on the newest version (2022)
}
\details{
aliases athb ATHB
}
\examples{
calcATHBx(20, 25, 25, .1, 50, 1.1, 'Office', 'Mixed Mode', 
'winter')
}
\references{
Schweiker & Wagner (2015) <doi:10.1016/j.buildenv.2015.08.018>
Schweiker (2022) <doi:10.1111/ina.13018>
}
\seealso{
see also \code{\link{calcComfInd}}, \code{link{calcATHBpts}}, \code{link{calcATHBset}},

\code{link{calcATHBpmv2015}}
}
\author{
Code implemented in to R by Shaomi Rahman. Further contribution by Marcel Schweiker.
}
