% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.set.R
\name{calibrate.set}
\alias{calibrate.set}
\title{Calculate the calibrated set of idea LRs}
\usage{
calibrate.set(
  LR.ss,
  LR.ds,
  method = c("raw", "laplace"),
  ties = c("none", "primary", "secondary", "tertiary")
)
}
\arguments{
\item{LR.ss}{a vector of likelihood ratios for the comparisons of items known to be from the same source}

\item{LR.ds}{a vector of likelihood ratios for the comparisons of items known to be from different sources}

\item{method}{the method used to perform the calculation, either \code{"raw"} or \code{"laplace"}}

\item{ties}{method to solve ties in the predictors list, either \code{"none"} (not solved) or \code{"primary"}, \code{"secondary"} or \code{"tertiary"} (passed to the isotone::gpava() function)}
}
\value{
a \code{list} with two items: \describe{
\item{LR.cal.ss}{calibrated LRs for the comparison for same set}
\item{LR.cal.ds}{calibrated LRs for the comparison for different set}
}
}
\description{
Calculates and returns the calibrated set of \verb{ideal' LRs from the observed LRs using the penalised adjacent violators algorithm. This is very much a rewrite of Nico Brummer's }optloglr()` function for Matlab.
}
\details{
This is an internal function, and is not meant to be called directly. However
it has been exported just in case.
}
\references{
Ramos, D. & Gonzalez-Rodriguez, J. (2008) Cross-entropy analysis of the information in forensic speaker recognition; IEEE Odyssey.

de Leeuw, J. & Hornik, K. & Mair, P., (2009), Isotone Optimization in R: Pool-Adjacent-Violators Algorithm (PAVA) and Active Set Methods, https://www.jstatsoft.org/article/view/v032i05
}
\seealso{
\code{\link[isotone:gpava]{isotone::gpava()}}, \code{\link[=calc.ece]{calc.ece()}}
}
\author{
David Lucy
}
