# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Internal function to compute iterative ratings
#'
#' C++ implementation of iterative computations.
#'
#' @param rate_fun Rating function (see Details).
#' @param player1_id Integer vector of player1 identifiers.
#' @param score1 Numeric vector of player1 score in games.
#' @param player2_id Integer vector of player2 identifiers.
#' @param score2 Numeric vector of player2 score in games.
#' @param initial_ratings Numeric vector of initial ratings (see Details).
#'
#' @details \code{rate_fun} - function that takes arguments:
#'   \itemize{
#'     \item rating1 - rating of player1 before game;
#'     \item score1 - numeric score of player1 in the game;
#'     \item rating2 - rating of player2 before game;
#'     \item score2 - numeric score of player2 in the game.
#'   }
#' This function should return numeric vector of length 2: rating of player1
#' and player2 after the game.
#'
#' \code{player1_id}, \code{player2_id} - integer vectors of identifiers of
#' players in a form of increasing numbers (1, 2, ...). Identifier 0 is
#' reserved for 'ghost' player. His/her rating is taken as current rating of
#' opponent. For two 'ghost' players ratings before and after are 0.
#'
#' \code{initial_ratings} - numeric vector of length equal to number of unique
#' players in \code{player1_id} and \code{player2_id}. In
#' \code{initial_ratings[player_id - 1]} (indexing from zero) initial rating of
#' player with identifier 'player_id' is stored.
#'
#' @return A list:
#' \itemize{
#'   \item rating1Before - rating of player 1 before the game;
#'   \item rating2Before - rating of player 2 before the game;
#'   \item rating1After - rating of player 1 after the game;
#'   \item rating2After - rating of player 2 after the game.
#' }
#' @keywords internal
compute_iterative_ratings <- function(rate_fun, player1_id, score1, player2_id, score2, initial_ratings) {
    .Call('_comperank_compute_iterative_ratings', PACKAGE = 'comperank', rate_fun, player1_id, score1, player2_id, score2, initial_ratings)
}

