% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{vcov.zlm}
\alias{vcov.zlm}
\alias{.vcov.aliased.complex}
\title{Calculate Variance-Covariance Matrix and Pseudo Variance-Covariance Matrix for a Complex Fitted Model Object}
\usage{
\method{vcov}{zlm}(object, complete = TRUE, merge = TRUE, ...)

.vcov.aliased.complex(aliased, vc, complete = TRUE)
}
\arguments{
\item{object}{Typically a fitted model object of class "zlm" and/or "rzlm". Sometimes also a summary() object of such a fitted model.}

\item{complete}{logical. Indicates if the full covariance and pseudo-covariance matrices should be returned even in the case of an over-determined system, meaning that some coefficients are undefined.}

\item{merge}{logical. Should the covariance matrix and pseudo-covariance / relational matrix be merged into one matrix of twice the dimensions? Default is TRUE.}

\item{...}{Additional parameters, not currently used for anything.}

\item{aliased}{a logical vector typically identical to \code{is.na(coef(.))} indicating which coefficients are 'aliased'.}

\item{vc}{a variance-covariance matrix, typically "incomplete", i.e., with no rows and columns for aliased coefficients.}
}
\value{
If \code{merge} is false, a list containing both the numeric variance-covariance matrix, and the complex pseudo variance-covariance matrix.
If \code{merge} is true, a large matrix (both dimensions being twice the number of coefficients) containing both the variance-covariance matrix and the pseudo variance-covariance matrix, merged together.
}
\description{
A method for of \link[stats:vcov]{stats::vcov} that is compatible with complex linear models. In addition to variance-covariance matrix,
the pseudo variance-covariance matrix, which is a measure of the covariance between real and imaginary components, is returned as well.
Can also return the "double covariance" matrix, which combines the information of the covariance matrix and the pseudo-covariance matrix, as described in (van den Bos 1995).
While not as compact as two separate smaller matrices, the double covariance matrix simplifies calculations such as the \link{mahalanobis} distance.
}
\section{Functions}{
\itemize{
\item \code{.vcov.aliased.complex()}: auxiliary function for dealing with singular model fits. See \link[stats:vcov]{stats::vcov}.

}}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
err <- complex(real = rnorm(n)/16, imaginary = rnorm(n)/16)
tframe <- data.frame(x= x <- complex(real=rnorm(n), imaginary= rnorm(n)), y=slop*x + interc+err)
fit <- lm(y ~ x, data = tframe, weights = rep(1,n))
vcov(fit)
}
\references{
A. van den Bos, The Multivariate Complex Normal Distribution-a Generalization, IEEE Trans. Inform. Theory 41, 537 (1995).
}
