% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superiority.R
\name{interpret_superiority}
\alias{interpret_superiority}
\title{Superiority test interpretations of confidence intervals.}
\usage{
interpret_superiority(ci, null_value = 0, groups = c("Control intervention",
  "Test intervention"), beneficial_outcome = TRUE)
}
\arguments{
\item{ci}{A single row from a matrix of the type returned by \code{confint()},
containing the confidence interval for the parameter estimate. The two
columns provide the lower and upper confidence limits.}

\item{null_value}{The value that precisely zero difference would have in
the parameter being examined. For an absolute measure this will typically
be 0. For a relative measure it will typically be 1. For superiority tests
this is the point value that the confidence interval is compared at.}

\item{groups}{A character vector of length 2 containing short descriptive names of the
groups being compared, such as the names of the interventions being
compared if the confidence interval is derived from an outcome effect
size measure in a randomised controlled trial. Give the name of the
intervention given to the comparison or control group first and the new
or tested intervention second.}

\item{beneficial_outcome}{Is the outcome to be treated as beneficial
(i.e., a higher value of the outcome is superior)? For harmful
outcomes (where lower numbers are better), set this to FALSE. If, for
example, the outcome is measuring something like prevalence of patients
recovering from a disease, that is likely to be beneficial; if it is
measuring the prevalence of patients falling ill with a disease it is
likely to be \strong{not} beneficial.}
}
\value{
A list object of class \code{\link{interpretation_result}} with
  elements stating the interpretation in different formats, plus the
  parameters used to generate the interpretation.
}
\description{
Conduct superiority tests on confidence intervals using a standard set of
interpretations. Takes a confidence interval around an effect size measure,
for example from the results from a randomised controlled trial comparing
the outcome for an intervention group to a control group.
}
\details{
You are able to supply descriptive names of the interventions being
compared, and these will be inserted into the resultant interpretation.
If the comparison / baseline intervention does not have a convenient name
(such as "Placebo"), some of these might be suitable:
\itemize{
 \item{"Business as usual"}
 \item{"Treatment as usual"}
 \item{"No intervention"}
}
(Whilst these may work well as short descriptions for outputting from
this function, in your reporting you will still normally want to provide
information about what exactly those in a comparison group got.)

This function is provided in the form of a convenience wrapper for
\code{\link{confinterpret}}, using
\code{\link{interpretations_superiority}} as its
\code{\link{interpretation_set}}.
}
\examples{
# Establish a test confidence interval
ci_test <- matrix(c(-0.1, 0.1),
                  nrow = 1, dimnames = list("estimate",
                                            c("2.5 \%", "97.5 \%")))
interpret_superiority(ci_test, 0, c("Treatment as usual", "New treatment"))

}
