% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpretation_result.R
\name{interpretation_result}
\alias{interpretation_result}
\title{Interpretation result}
\usage{
interpretation_result(interpretation, ci, interpretation_set,
  interpretation_set_name = deparse(substitute(interpretation_set)),
  boundaries, comparison_labels, low_to_high)
}
\arguments{
\item{interpretation}{A list object from a an \code{\link{interpretation_set}} providing the
qualitative interpretation.}

\item{ci}{The confidence interval that was interpreted.}

\item{interpretation_set}{The \code{\link{interpretation_set}} object that was used to conduct the
interpretation.}

\item{interpretation_set_name}{The name of the \code{interpretation_set} that was used for the
interpretation.}

\item{boundaries}{The boundaries parameter that was used for the interpretation.}

\item{comparison_labels}{Labels that were used to describe the groups that were compared in the
interpretation.}

\item{low_to_high}{Whether the boundaries were provided in low-to-high or high-to-low order.}
}
\value{
A list object of class \code{interpretation_result} with elements
  stating the interpretation in different formats
  (\code{$interpretation_short}, \code{$interpretation}, and
  \code{$interpretation_md}) and \code{$parameters}. \code{$parameters} is
  list object detailing the parameters that were used to generate the
  interpretation, and contains
  \code{$ci},
  \code{$interpretation_set},
  \code{$interpretation_set_name},
  \code{$boundaries},
  \code{$comparison_labels} and
  \code{$low_to_high}.
}
\description{
A class to define the result that is returned by an interpretation conducted
by \code{\link{confinterpret}}.
}
\details{
The parameters are the ones that were used in conducting the interpretation
(typically using \code{confinterpret} or one of its convenience wrapper
functions). See \code{\link{confinterpret}} for more details on how these
parameters were used in conducting the interpretation.
}
