% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.interpretation_result}
\alias{plot.interpretation_result}
\title{Plot an interpretation_result, as returned by confinterpret()}
\usage{
\method{plot}{interpretation_result}(x, extra_boundaries = NULL,
  estimate = NULL, boundary_values = TRUE, boundary_label_pos = "below",
  interpretation_label_pos = "right", x_axis_pos = "below",
  y_axis_pos = "none", inner_margin = c(-0.1, 0.05, -0.1, 0.05),
  edge_margin = c(0, 0.02, 0, 0.02), edge_type = "gradient",
  interval_type = "norm", interval_value_labels = TRUE,
  estimate_value_labels = TRUE, plot_estimate_marks = TRUE,
  estimate_mark_points = c(0, 0.05, 0, -0.05), ...)
}
\arguments{
\item{x}{An \code{interpretation_result} object, of the type returned by
\code{\link{confinterpret}}.}

\item{extra_boundaries}{A vector of numerical values specifying the position for displaying
additional boundaries, not specified in the \code{interpretation_set}.
May optionally be named values; if named, the names will be labelled
on the plot axis.}

\item{estimate}{Estimate value that the interval relates to. If not specified, a default
of the central point between the two ends of the interval will be assumed.}

\item{boundary_values}{A logical value indicating whether the values should be appended to
the boundaries' names.}

\item{boundary_label_pos}{Where to put the boundary labels.
Options are \code{c("below", "above", "on top", "none")}.
If you are planning to plot values on the canvas and want the boundary
labels on top then you may want to choose "none" and make a call to
\code{label_ontop_boundaries()} after plotting values.}

\item{interpretation_label_pos}{Options are \code{c("right", "left", "none")}}

\item{x_axis_pos}{Location of a numerical x axis.
Options are \code{c("none", "below", "above")}.}

\item{y_axis_pos}{Location of a numerical y axis. Default "none" will almost always be right.
Options are c\code{("none", "left", "right")}.}

\item{inner_margin}{Numerical vector of the form \code{c(bottom, left, top, right)}, which
gives the amount of inner margin to be added, expressed as a proportion
of the plotted area. This is space designed to be past any plotted objects
but before the edging (defined separately via \code{edge_margin}).
See Details.}

\item{edge_margin}{Numerical vector of the form \code{c(bottom, left, top, right)}, which gives
the amount of 'edge margin' to be added, expressed as a proportion of the
plotted width. This is the space designed to be occupied by plot edges
(e.g. a gradient fading out). Currently only implemented for left and
right; top and bottom values are ignored. See Details.}

\item{edge_type}{What style of edge to draw at the sides of the plot. Currently supported
options are \code{"gradient"} (the default) and \code{"zigzag"}.}

\item{interval_type}{Set the way the interval is presented. Current options are
\code{c("norm", "unif")} for a normal distribution-based curve
and a box, respectively.}

\item{interval_value_labels}{Logical value specifying whether interval value labels are to be added.}

\item{estimate_value_labels}{Logical value specifying whether estimate value labels are to be added.}

\item{plot_estimate_marks}{Whether to plot marks at the x location of the estimates.}

\item{estimate_mark_points}{y positions of the ends of the estimate marks as a numeric vector of length
4. Values are, in order: start (relative to centre), end (relative to box
top), start (relative to centre), end (relative to box bottom).}

\item{...}{Further arguments passed to and from methods.}
}
\description{
Produces a diagram that illustrates the confidence interval that was
interpreted using \code{\link{confinterpret}} against a background
illustrating the \code{\link{interpretation_set}} that it was the basis for
the interpretation.
}
\details{
Additional boundaries can be displayed using the \code{extra_boundaries}
parameter. This can be helpful if you want to show a position that is
of some practical relevance, but is not defined as a boundary for the
purposes of the \code{interpretation_set}.

If you wish to plot multiple \code{interpretation_result} objects on one
chart, see \code{\link{plot_interpretation_result_list}}.

Plots use the current R Graphics Palette, so you may wish to set that to
something attractive before plotting. See ?palette.
}
\examples{
# Set a nice colour scheme
grDevices::palette(c("#FF671F99", "#F2A90099", "#0085CA99"))
# Set up a confidence interval to interpret
ci_test <- matrix(c(-0.03, 0.05),
                  nrow = 1,
                  dimnames = list("estimate", c("2.5 \%", "97.5 \%")))
noninf <- interpret_noninferiority(ci_test, 0, 0.05, c("Treatment as usual",
                                                       "New treatment"))
plot(noninf)

}
