% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisplit.R
\name{conformal.multidim.msplit}
\alias{conformal.multidim.msplit}
\title{Multi Split conformal prediction intervals with Multivariate Response}
\usage{
conformal.multidim.msplit(
  x,
  y,
  x0,
  train.fun,
  predict.fun,
  alpha = 0.1,
  split = NULL,
  seed = FALSE,
  randomized = FALSE,
  seed_beta = FALSE,
  verbose = FALSE,
  training_size = NULL,
  score = "max",
  s_type = "st-dev",
  B = 100,
  lambda = 0,
  tau = 1 - (B + 1)/(2 * B)
)
}
\arguments{
\item{x}{Feature matrix of dimension n x p.}

\item{y}{Response matrix of dimension n x q.}

\item{x0}{New points to evaluate, matrix of dimension n0 x p.}

\item{train.fun}{Function to perform model training, producing an estimator of E(Y|X).
Input arguments: x (features), y (responses).}

\item{predict.fun}{Function to predict responses at new feature values.
Input arguments: out (output from train.fun), newx (new features).}

\item{alpha}{Miscoverage level for prediction intervals. Default 0.1.}

\item{split}{Indices defining the training split. Default NULL (random split).}

\item{seed}{Integer seed for random split. Ignored if split is provided. Default FALSE.}

\item{randomized}{Logical, whether to use the randomized approach. Default FALSE.}

\item{seed_beta}{Seed for the randomized version. Default FALSE.}

\item{verbose}{Logical, print progress? Default FALSE.}

\item{training_size}{Proportion of data used for training. Default 0.5.}

\item{score}{Nonconformity measure to use for the split conformal function.}

\item{s_type}{Type of modulation function: "identity", "st-dev", or "alpha-max". Default "st-dev".}

\item{B}{Number of repetitions. Default 100.}

\item{lambda}{Smoothing parameter. Default 0.}

\item{tau}{Smoothing parameter for intersection method:
\describe{
  \item{tau = 1 - 1/B}{Bonferroni intersection method.}
  \item{tau = 0}{Unadjusted intersection.}
}
Default 1 - (B + 1)/(2 * B).}
}
\value{
A list with components x0, lo, and up. lo and up are matrices of dimension n0 x q.
}
\description{
Compute prediction intervals using Multi Split conformal inference for a
multivariate response.
}
\details{
This function extends the univariate Multi Split conformal approach to the multivariate case.
  Parallelization is performed via the \code{\link[future.apply]{future_sapply}} function.
}
\examples{

n = 33
n0 = 2
p = 2
mu = rep(0,p)
x = mvtnorm::rmvnorm(n, mu)
my_grid <- seq(from=0,to=1,length.out=2)
y = t(apply(x,1,function(u) u[1] + u[2]*cos(6*pi*my_grid)))
x0 = mvtnorm::rmvnorm(n0, mu)
fun=mean_multi()
#fun=lm_multi()

B=3

final.multi=conformal.multidim.msplit(x=x,y=y, x0=x0,
                                      fun$train.fun, fun$predict.fun,
                       alpha=0.1,
                       split=NULL, seed=FALSE, randomized=FALSE,seed_beta=FALSE,
                       verbose=FALSE, training_size=NULL,s_type="st-dev",B=B,lambda=0,
                       score="l2")



}
\references{
Solari, Djordjilovic (2021), "Multi Split Conformal Prediction" (baseline for univariate case)
}
