% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_record.R
\name{cong_daily_record}
\alias{cong_daily_record}
\title{Request daily Congressional Record Information}
\usage{
cong_daily_record(
  volume = NULL,
  issue = NULL,
  item = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{volume}{Volume of the daily Congressional record. Character (or numeric).}

\item{issue}{Issue of the daily Congressional record. Character (or numeric).}

\item{item}{Information to request. Can be \code{'articles'}}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
a \code{tibble::tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request daily Congressional Record Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Requires API Key

cong_daily_record()

cong_daily_record(volume = 166)

cong_daily_record(volume = 168, issue = 153)

cong_daily_record(volume = 167, issue = 21, item = 'articles')
\dontshow{\}) # examplesIf}
}
