% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consort_plot.R
\name{consort_plot}
\alias{consort_plot}
\title{Self generating consort diagram}
\usage{
consort_plot(
  data,
  orders,
  side_box,
  allocation = NULL,
  labels = NULL,
  kickoff_sidebox = TRUE,
  cex = 0.8,
  text_width = NULL
)
}
\arguments{
\item{data}{Data set with disposition information for each participants.}

\item{orders}{A named vector or a list, names as the variable in the dataset
and values as labels in the box. The order of the diagram will be based on this.
A list can be used to report multiple variable in a single node, the first 
variable in a list element will be used to report the total and the exact items
will be summarised for the remaining variable. This is limitted to non-side box.}

\item{side_box}{Variable vector, appeared as side box in the diagram. The next
box will be the subset of the missing values of these variables.}

\item{allocation}{Name of the grouping/treatment variable (optional), the
 diagram will split into branches on this variables forward. For a factorial 
design, with two splits for example, a character vector with a maximum of 
length two can be provided. The extra box will be skipped if the values
 in the \code{orders} blank.}

\item{labels}{Named vector, names is the location of the terminal node. The
position location should plus 1 after the allocation variables if the allocation
is defined.}

\item{kickoff_sidebox}{remove (default) the side box observations from the 
following counting.}

\item{cex}{Multiplier applied to font size, Default is 0.8}

\item{text_width}{a positive integer giving the target column for wrapping
lines in the output. String will not be wrapped if not defined (default).
The \code{\link[stringi]{stri_wrap}} function will be used if \code{stringi}
package installed, otherwise \code{\link[base]{strwrap}} will be used.}
}
\value{
A \code{consort} object.
}
\description{
Create CONSORT diagram from a participant disposition data.
}
\details{
The calculation of numbers is as in an analogous to Kirchhoff's Laws of
electricity. The numbers in terminal nodes must sum to those in the ancestor
 nodes. All the drop outs will be populated as a side box. Which was different
  from the official CONSORT diagram template, which has dropout inside a
  vertical node.
}
\examples{

## Prepare test data
data(dispos.data)

df <- dispos.data[!dispos.data$arm3 \%in\% "Trt C", ]
p <- consort_plot(data = df,
                  orders = list(c(trialno = "Population"),
                                c(exclusion = "Excluded"),
                                c(arm     = "Randomized patient"),
                                c(arm3     = "", 
                                  subjid_notdosed="Participants not treated"),
                                c(followup    = "Pariticpants planned for follow-up",
                                  lost_followup = "Reason for tot followed"),
                                c(assessed = "Assessed for final outcome"),
                                c(no_value = "Reason for not assessed"),
                                c(mitt = "Included in the mITT analysis")),
                  side_box = c("exclusion", "no_value"),
                  allocation = c("arm", "arm3"),
                  labels = c("1" = "Screening", "2" = "Randomization",
                             "5" = "Follow-up", "7" = "Final analysis"),
                  cex = 0.7)
}
\seealso{
\code{\link{add_side_box}},\code{\link{add_split}},
\code{\link{add_side_box}} \code{\link{textbox}}
}
