% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-DequeS3.R, R/GroupGenericMath.R,
%   R/GroupGenericSummary.R, R/Ops-arithmetic.R, R/addleft.R, R/peek.R, R/pop.R,
%   R/rev.R, R/rotate.R
\name{DequeS3}
\alias{DequeS3}
\alias{deque}
\alias{as.deque}
\alias{is.deque}
\title{Deque - Double-Ended Queue}
\usage{
deque(...)

as.deque(x)

is.deque(x)
}
\arguments{
\item{...}{initial elements put into the \code{Deque}.}

\item{x}{\code{R} object of \code{ANY} type for \code{\link[=as.deque]{as.deque()}} and \code{\link[=is.deque]{is.deque()}}
or of class \code{Deque} for the \code{S3} methods.}
}
\description{
Deques are a generalization of stacks and queues typically
with methods to add, remove and access elements at both sides of the
underlying data sequence. As such, the \link{deque} can also be used to mimic
both stacks and queues.
}
\details{
Methods that alter \link{Deque} objects usually come in two versions
providing either copy or reference semantics where the latter start with
\code{'ref_'} to note the reference semantic, for example, \code{add()} and
\code{ref_add()}.

\itemize{
\item \code{deque(...)} initializes and returns an object of class \code{Deque}
}

\itemize{
\item \code{as.deque(x)} coerces \code{x} to a deque.
}

\itemize{
\item \code{is.deque(x)} returns \code{TRUE} if \code{x} is of class \code{Deque}
and \code{FALSE} otherwise.
}

\itemize{
\item \code{x + y} combines \code{x} and \code{y} into a new deque by appending \code{y}
to \code{x}.
}

\itemize{
\item \code{x - y} element-wise removes all items of \code{y} from \code{x}, given
the element was contained in \code{x}.
}

\itemize{
\item \code{addleft(.x, ...)} adds (possibly named) elements to left side of \code{.x}.
\item \code{ref_addleft(.x, ...)} same as \code{addleft(.x, ...)} but adds by reference.
}

\itemize{
\item \code{peek(x, default = NULL)} peek at last element. If \code{x} is empty, return
\code{default}.
\item \code{peekleft(x, default = NULL)} peek at first element. If \code{x} is empty,
return \code{default}.
}

\itemize{
\item \code{ref_pop(.x)} pop last element. If \code{.x} is empty, an error is given.
\item \code{ref_popleft(.x)} pop first element. If \code{.x} is empty, an error is given.
}

\itemize{
\item \code{rev(x)} and \code{ref_rev(x)} reverses all elements being done on a copy or in
place, respectively.
}

\itemize{
\item \code{rotate(x, n)} rotate all elements \code{n} steps to the right, If \code{n} is
negative, rotate to the left.
}
}
\examples{
d = deque(1, 2, s = "a", v = 1:3)
is.deque(d)
print(d)
length(d)
names(d)
as.list(d)
rev(d)

l = list(0, 1)
d2 = as.deque(l)
d + d2
c(d, d2) # same as d + d2
d2 + d
d - d2
c(d2, d) # same as d2 + d
d2 - d
# Math
d = deque(1, 2, -(3:5))
d
abs(d)
cumsum(d)
round(d)
exp(d)

# Summary
range(d)
min(d)
max(d)

d1 = deque(1, 1:2)
d2 = deque(2, 1:2)
d1 + d2     # same as c(d1, d2)
d2 + d1     # same as c(d2, d1)

d1 - d2
d2 - d1
d1 - d1


d = deque(0)
add(d, a = 1, b = 2)         # |0, a = 1, b = 2|
addleft(d, a = 1, b = 2)     # |b = 2, a = 1, 0|

d = deque(1, 2, 3)
peek(d)
peekleft(d)
peek(deque())
peek(deque(), default = 0)
peekleft(deque(), default = 0)
d = deque(1, 2, 3)
ref_pop(d)
print(d)
ref_popleft(d)
print(d)

try({
ref_pop(deque())  # pop at empty Deque
})

d = deque(a = 1, b = 2, 3)
rev(d)
print(d)
ref_rev(d)
print(d)

d = deque(1, 2, 3, 4)
rotate(d)
rotate(d, n = 2)

}
\seealso{
See \code{\link[=container]{container()}} for all inherited methods. For the full class
documentation see \code{\link[=Deque]{Deque()}} and it's superclass \link[=container]{Container()}.
}
