% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-SetR6.R
\name{Set}
\alias{Set}
\title{Set Class}
\description{
The \link{Set} is considered and implemented as a specialized
\link{Container}, that is, elements are always unique in the \link{Container} and
it provides typical set operations such as \code{union} and \code{intersect}.
For the standard S3 interface, see \code{\link[=setnew]{setnew()}}.
}
\examples{
s1 = Set$new(1, 2)
s1
s1$add(1)
s1$add(3)
s2 = Set$new(3, 4, 5)
s1$union(s2)
s1

s1 = Set$new(1, 2, 3)
s1$intersect(s2)
s1

s1$diff(s2)
s1$diff(s1)
s1
}
\seealso{
\link{Container}, \code{\link[=setnew]{setnew()}}
}
\section{Super classes}{
\code{\link[container:Iterable]{container::Iterable}} -> \code{\link[container:Container]{container::Container}} -> \code{Set}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Set-new}{\code{Set$new()}}
\item \href{#method-Set-add}{\code{Set$add()}}
\item \href{#method-Set-diff}{\code{Set$diff()}}
\item \href{#method-Set-intersect}{\code{Set$intersect()}}
\item \href{#method-Set-union}{\code{Set$union()}}
\item \href{#method-Set-is_equal}{\code{Set$is_equal()}}
\item \href{#method-Set-is_subset}{\code{Set$is_subset()}}
\item \href{#method-Set-is_proper_subset}{\code{Set$is_proper_subset()}}
\item \href{#method-Set-values}{\code{Set$values()}}
\item \href{#method-Set-clone}{\code{Set$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="container" data-topic="Iterable" data-id="iter"><a href='../../container/html/Iterable.html#method-Iterable-iter'><code>container::Iterable$iter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at"><a href='../../container/html/Container.html#method-Container-at'><code>container::Container$at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at2"><a href='../../container/html/Container.html#method-Container-at2'><code>container::Container$at2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="clear"><a href='../../container/html/Container.html#method-Container-clear'><code>container::Container$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="count"><a href='../../container/html/Container.html#method-Container-count'><code>container::Container$count()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete"><a href='../../container/html/Container.html#method-Container-delete'><code>container::Container$delete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete_at"><a href='../../container/html/Container.html#method-Container-delete_at'><code>container::Container$delete_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard"><a href='../../container/html/Container.html#method-Container-discard'><code>container::Container$discard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard_at"><a href='../../container/html/Container.html#method-Container-discard_at'><code>container::Container$discard_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="empty"><a href='../../container/html/Container.html#method-Container-empty'><code>container::Container$empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="get_compare_fun"><a href='../../container/html/Container.html#method-Container-get_compare_fun'><code>container::Container$get_compare_fun()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has"><a href='../../container/html/Container.html#method-Container-has'><code>container::Container$has()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has_name"><a href='../../container/html/Container.html#method-Container-has_name'><code>container::Container$has_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="is_empty"><a href='../../container/html/Container.html#method-Container-is_empty'><code>container::Container$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="length"><a href='../../container/html/Container.html#method-Container-length'><code>container::Container$length()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="names"><a href='../../container/html/Container.html#method-Container-names'><code>container::Container$names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at"><a href='../../container/html/Container.html#method-Container-peek_at'><code>container::Container$peek_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at2"><a href='../../container/html/Container.html#method-Container-peek_at2'><code>container::Container$peek_at2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="pop"><a href='../../container/html/Container.html#method-Container-pop'><code>container::Container$pop()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="print"><a href='../../container/html/Container.html#method-Container-print'><code>container::Container$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="remove"><a href='../../container/html/Container.html#method-Container-remove'><code>container::Container$remove()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="rename"><a href='../../container/html/Container.html#method-Container-rename'><code>container::Container$rename()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace"><a href='../../container/html/Container.html#method-Container-replace'><code>container::Container$replace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace_at"><a href='../../container/html/Container.html#method-Container-replace_at'><code>container::Container$replace_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="size"><a href='../../container/html/Container.html#method-Container-size'><code>container::Container$size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="type"><a href='../../container/html/Container.html#method-Container-type'><code>container::Container$type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="update"><a href='../../container/html/Container.html#method-Container-update'><code>container::Container$update()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-new"></a>}}
\if{latex}{\out{\hypertarget{method-Set-new}{}}}
\subsection{Method \code{new()}}{
\code{Set} constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{initial elements put into the \code{Set}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Set} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-add"></a>}}
\if{latex}{\out{\hypertarget{method-Set-add}{}}}
\subsection{Method \code{add()}}{
Add element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$add(value, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value of \code{ANY} type to be added to the \code{Set}.}

\item{\code{name}}{\code{character} optional name attribute of the value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-diff"></a>}}
\if{latex}{\out{\hypertarget{method-Set-diff}{}}}
\subsection{Method \code{diff()}}{
\code{Set} difference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$diff(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to 'subtract'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object updated as a result of the set difference
between this and s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-intersect"></a>}}
\if{latex}{\out{\hypertarget{method-Set-intersect}{}}}
\subsection{Method \code{intersect()}}{
\code{Set} intersection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$intersect(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to 'intersect'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object as a result of the intersection of this
and s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-union"></a>}}
\if{latex}{\out{\hypertarget{method-Set-union}{}}}
\subsection{Method \code{union()}}{
\code{Set} union
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$union(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to be 'unified'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object as a result of the union of this and s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-is_equal"></a>}}
\if{latex}{\out{\hypertarget{method-Set-is_equal}{}}}
\subsection{Method \code{is_equal()}}{
\code{Set} equality
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$is_equal(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to compare against}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if this is equal to \code{s}, otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-is_subset"></a>}}
\if{latex}{\out{\hypertarget{method-Set-is_subset}{}}}
\subsection{Method \code{is_subset()}}{
\code{Set} proper subset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$is_subset(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to compare against}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if this is subset of \code{s}, otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-is_proper_subset"></a>}}
\if{latex}{\out{\hypertarget{method-Set-is_proper_subset}{}}}
\subsection{Method \code{is_proper_subset()}}{
\code{Set} subset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$is_proper_subset(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to compare against}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if this is proper subset of \code{s}, otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-values"></a>}}
\if{latex}{\out{\hypertarget{method-Set-values}{}}}
\subsection{Method \code{values()}}{
Get \code{Set} values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$values()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
elements of the set as a base list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Set-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
