% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_contrasts.R
\name{set_contrasts}
\alias{set_contrasts}
\title{Set contrasts to factor columns in dataframe}
\usage{
set_contrasts(
  model_data,
  ...,
  verbose = getOption("contrastable.verbose"),
  .droplevels = getOption("contrastable.droplevels"),
  print_contrasts = FALSE
)
}
\arguments{
\item{model_data}{Data frame you intend on passing to your model}

\item{...}{A series of 2 sided formulas with factor name on the left hand
side and desired contrast scheme on the right hand side. The reference
level can be set with \code{+}, the intercept can be overwritten with \code{*},
comparison labels can be set using \code{|}, and trends for polynomial coding
can be removed using \code{-}.}

\item{verbose}{Logical, defaults to TRUE, whether messages should be printed.
See \code{Options("contrastable.verbose")}}

\item{.droplevels}{Logical, defaults to TRUE, whether missing levels from
existing factor columns should be dropped before applying new contrasts. See
\code{Options("contrastable.droplevels")}}

\item{print_contrasts}{Logical, default FALSE, whether to print the contrasts
set for each factor. Fractions are displayed using \code{\link[MASS:fractions]{MASS::fractions()}}}
}
\value{
The \code{model_data} dataframe, but with updated contrasts.
}
\description{
Uses the same syntax as \code{\link[=enlist_contrasts]{enlist_contrasts()}},
but returns the dataframe with the new contrasts applied. Use this when
your model function doesnt have a contrasts argument and you want to avoid
writing \verb{contrasts<-} multiple times. See \code{\link[=enlist_contrasts]{enlist_contrasts()}} for details
about the package-specific syntax.
}
\details{
\code{\link[=enlist_contrasts]{enlist_contrasts()}}, \code{\link[=set_contrasts]{set_contrasts()}},
and \code{\link[=glimpse_contrasts]{glimpse_contrasts()}} use special syntax to set
contrasts for multiple factors. The syntax consists of two-sided formulas
with the desired factor column on the left hand side and the contrast
specification on the right hand side. For example, \code{varname ~ scaled_sum_code}. Many contrasts support additional kinds of contrast
manipulations using overloaded operators:
\itemize{
\item \code{+ X}: Set the reference level to the level named X. Only supported for
schemes that have a singular reference level such as
\code{\link[=sum_code]{sum_code()}}, \code{\link[=scaled_sum_code]{scaled_sum_code()}},
\code{\link[=treatment_code]{treatment_code()}}, \code{\link[stats:contrast]{stats::contr.treatment()}},
\code{\link[stats:contrast]{stats::contr.sum()}}, \code{\link[stats:contrast]{stats::contr.SAS()}}. Ignored for schemes like
\code{\link[=helmert_code]{helmert_code()}}.
\item \verb{* X}: Overwrite the intercept to the mean of the level named X
\item \code{- A:B}: For polynomial coding schemes only, drop comparisons A through B.
\item \verb{| c(...)}: Change the comparison labels for the contrast matrix to the
character vector \code{c(...)} of length \code{n-1}. These labels will appear in the
output/summary of a statistical model. Note that for \code{brms::brm},
instances of \code{-} (a minus sign) are replaced with \code{M}.
}

You can also specify multiple variables on the left hand side of a formula
using tidyselect helpers. See examples for more information.

Typically model functions like lm will have a contrasts argument where you
can set the contrasts at model run time, rather than having to manually
change the contrasts on the underlying factor columns in your data. This
function will return such a named list of contrast matrices to pass to these
functions. Note that this function should not be used within a modeling
function call, e.g., \code{lm(y~x, data = model_data, contrasts =
enlist_contrasts(model_data, x~sum_code))}. Often, this will call
\code{enlist_contrasts} twice, rather than just once.

For some model fitting functions, like \code{brms::brm}, there is no
contrasts argument. For such cases, use \code{\link[=set_contrasts]{set_contrasts()}} to
set contrasts directly to the factors in a dataframe.

One good way to use \code{\link[=enlist_contrasts]{enlist_contrasts()}} is in conjunction
with \code{\link[MASS:fractions]{MASS::fractions()}} to create a list of matrices that can be printed
to explicitly show the entire contrast matrices you're using for your models.
This can be especially helpful for supplementary materials in an academic
paper.

Sometimes when using orthogonal polynomial contrasts from
\code{\link[stats:contrast]{stats::contr.poly()}} people will drop higher level polynomials for
parsimony. Note however that these do capture some amount of variation, so
even though they're orthogonal contrasts the lower level polynomials will
have their estimates changed. Moreover, you cannot reduce a contrast matrix
to a matrix smaller than size n*n-1 in the dataframe you pass to a model
fitting function itself, as R will try to fill in the gaps with something
else. If you want to drop contrasts you'll need to use something like
\code{enlist_contrasts(df, x ~ contr.poly - 3:5)} and pass this to the
\code{contrasts} argument in the model fitting function.
}
\examples{

head(
   set_contrasts(mtcars, carb + cyl ~ helmert_code, print_contrasts = TRUE)
)

}
\seealso{
\code{\link[=enlist_contrasts]{enlist_contrasts()}} \code{\link[=glimpse_contrasts]{glimpse_contrasts()}}
}
