% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abso_change.R
\name{abso_change}
\alias{abso_change}
\title{Absolute change}
\usage{
abso_change(tavDes, time_0, time_t, all_within = TRUE, timeName = "time")
}
\arguments{
\item{tavDes}{the sorted dataframe time by countries.
No other variables besides time and countries' indicator
must be present.}

\item{time_0}{reference time}

\item{time_t}{focus time strictly larger than time_0}

\item{all_within}{is TRUE is several times are considered within the
specified interval (default), otherwise FALSE; the reference time remains
time_0.}

\item{timeName}{the name of the variable that contains time information}
}
\value{
a list of absolute changes for each country, the sum of absolute values and the average per pairs
        of years.
}
\description{
Given a dataframe of quantitative indicators along time,
the absolute change is calculated.
A time variable must be present and sorted.
Missing values are not allowed. All other columns are indicator values
in each considered country.
}
\examples{

# Example 1
# Sorted dataframe in the format years by countries:
require(tibble)
testTB <- dplyr::tribble(
~years, ~countryA ,  ~countryB,  ~countryC,
2000,     0.8,   2.7,    3.9,
2001,     1.2,   3.2,    4.2,
2002,     0.9,   2.9,    4.1,
2003,     1.3,   2.9,    4.0,
2004,     1.2,   3.1,    4.1,
2005,     1.2,   3.0,    4.0)

# Absolute change for each country with time_0=2000 and time_t=2005:
mySTB<-abso_change(tavDes=testTB,time_0=2000, time_t=2005, timeName ="years")

# The component "res" is a list of absolute changes for each country,
# the sum of absolute values and the average per pairs of years:
names(mySTB$res)

# Absolute change for each country with time_0=2002 and time_t=2005:
mySTB1<-abso_change(tavDes=testTB,time_0=2002, time_t=2005, timeName="years")

# If all_within is FALSE, only times 2002 and 2005 are considered:
mySTB2<-abso_change(tavDes=testTB,time_0=2002, time_t=2005, all_within =FALSE, timeName="years")

# Example 2
# Absolute changes of Member States for the emp_20_64_MS Eurofound dataset:
data(emp_20_64_MS)
mySTB3 <- abso_change(emp_20_64_MS,time_0 = 2005,time_t = 2010,timeName = "time")
mySTB4 <- abso_change(emp_20_64_MS,time_0 = 2007,time_t = 2012,timeName = "time")



}
\references{
{ \url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
