% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_clust.R
\name{average_clust}
\alias{average_clust}
\title{Unweighted average of countries}
\usage{
average_clust(myTB, timeName = "time", cluster = "EU27")
}
\arguments{
\item{myTB}{time by member states dataset.}

\item{timeName}{name of the variable that contains time.}

\item{cluster}{the label defining a cluster; one string selected within
the following: "EU12" , "EU15" ,"EU19","EU25" ,"EU27_2007", "EU28", "EU27_2020",
"Eurozone","EA", "all" (for all countries in the dataset).}
}
\value{
The dataset with the average of clustered countries.
}
\description{
The computation is based on clusters defined in a objects
created by invoking *convergEU_glb()*.
At now only cluster labels contained into *convergEU_glb()* are possible.
}
\details{
The cluster specification is based on labels:  "EU27_2020", "EU27_2007", "EU25", "EU19",
"EU15", "EU12","EA", "Eurozone", "all".
The option cluster = "all"  indicates that all countries in the dataset
have to be considered.
}
\examples{

# Example 1
# Unweighted average of Member States for cluster "EU12":
myAC1<-average_clust(emp_20_64_MS,timeName = "time",cluster = "EU12")

#  Visualize results for Italy:
myAC1$res[,c(1,17)]

# Visualize results for the first five member states:
myAC1$res[,c(1:6)]

# Example 2
# Unweighted average of Member States for cluster "EU25":
myAC2<-average_clust(emp_20_64_MS,timeName = "time",cluster = "EU25")

# Visualize results for France:
myAC2$res[,c(1,13)]

# Visualize results for the first six member states:
myAC2$res[,c(1:7)]

# Example 3
# Unweighted average of countries for cluster "EU27":
myAC<-average_clust(emp_20_64_MS,timeName = "time",cluster = "EU27")

# Visualize results for Germany:
myAC$res[,c(1,7)]

# Visualize results for the first five member states:
myAC$res[,c(1:6)]

}
\references{
{ \url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
