% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergEU_glb.R
\name{convergEU_glb}
\alias{convergEU_glb}
\title{Global objects for convergEU package}
\usage{
convergEU_glb()
}
\value{
a list of constants and objects for package convergEU
}
\description{
This is a list of constants and setups for the package. In this function that generates global static objects
and tables, cluster of countries are stored with their corresponding labels as well as indicators information
and labels.
}
\details{
Note that EU27 refers to Member States after the 1st February 2020, while EU28 is a valid
tag up to 31 March 2020. String EU27_2020 and EU27_2007 as defined by Eurofound are also
available.

The following clusters of countries are stored: EU12, EU15, EU25,
          EU27, EA, Euroarea. Current Member States are elements of EU27_2020.
         The cluster geoRefEUF is composed of both Member States and other countries
         (neighboring countries). The component "metaEUstat" contains the indicators'
         information, while the component "paralintags" is for defining patterns for the Member States.
}
\examples{

# Member States in the cluster Euroarea:
convergEU_glb()$Euroarea

# Cluster EU12 of Member States:
convergEU_glb()$EU12

# Cluster EU27 of Member States after 31 jan 2020:
convergEU_glb()$EU27

# Cluster EU28 of Member States up to jan 2020:
convergEU_glb()$EU28

# The countries in the cluster geoRefEUF:
convergEU_glb()$geoRefEUF

# Metainformation on indicators of the European Union:
convergEU_glb()$metaEUStat

}
\references{
{ \url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
