% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_departure.R
\name{graph_departure}
\alias{graph_departure}
\title{Graphical representation based on sigma convergence}
\usage{
graph_departure(
  myTB,
  timeName = "time",
  indiType = "highBest",
  displace = 0.25,
  displaceh = 0.45,
  dimeFontNum = 6,
  myfont_scale = 1.35,
  x_angle = 45,
  color_rect = c(`-1` = "red1", `0` = "gray80", `1` = "lightskyblue1"),
  axis_name_y = "Countries",
  axis_name_x = "Time",
  alpha_color = 0.9
)
}
\arguments{
\item{myTB}{the component $res$departure of an object created by
\code{departure_mean()}}

\item{timeName}{name of the time variable}

\item{indiType}{indicator type, one among "highBest" and "lowBest"}

\item{displace}{rectangle half height}

\item{displaceh}{rectangle half base}

\item{dimeFontNum}{size of font}

\item{myfont_scale}{axes magnification}

\item{x_angle}{angle of x axis labels}

\item{color_rect}{colors within rectangles; the default for a "highBest" indicator type is red for
"-1", grey for "0" and light sky blue for "1"; the default for a "lowBest" indicator type is light
 sky blue for "-1", grey for "0" and red for "1"}

\item{axis_name_y}{name of y axis}

\item{axis_name_x}{name of x axis}

\item{alpha_color}{transparency}
}
\value{
a list with component $res made by a ggplot object to be displayed
         or saved using ggsave function.
}
\description{
A ggplot object countries by time where coloured rectangles show if in that
time unit the indicator is below one standard deviation (-1) from the mean,
above one standard deviation (-1) from the mean or within 2 standard
deviations around the mean.
}
\details{
Note that  calculation of departure must be already performed by invoking
\code{\link{departure_mean}}.
}
\examples{

\donttest{
# Example 1: "lowBest" indicator type:
# Dataframe in the format time by countries:
require(tibble)
testTB <- dplyr::tribble(
   ~time, ~countryA ,  ~countryB,  ~countryC,
   2000,     0.8,   2.7,    3.9,
   2001,     1.2,   3.2,    4.2,
   2002,     0.9,   2.9,    4.1,
   2003,     1.3,   2.9,    4.0,
   2004,     1.2,   3.1,    4.1,
   2005,     1.2,   3.0,    4.0
   )
mySTB <- sigma_conv(testTB)
resDM <-  departure_mean(oriTB=testTB, sigmaTB=mySTB$res)
myG <- NULL
myG <- graph_departure(resDM$res$departures,
                       timeName = "time",
                       indiType = "lowBest",
                       displace = 0.25,
                       displaceh = 0.45,
                       dimeFontNum = 6,
                       myfont_scale = 1.35,
                       x_angle = 45,
                       axis_name_y = "Countries",
                       axis_name_x = "Time",
                       alpha_color = 0.9)
# Change the colour of rectangles:
myGG <- graph_departure(resDM$res$departures,
                       timeName = "time",
                       indiType = "lowBest",
                       displace = 0.25,
                       displaceh = 0.45,
                       dimeFontNum = 6,
                       myfont_scale = 1.35,
                       x_angle = 45,
                       color_rect = c("-1"='green4', "0"='yellow',"1"='red'),
                       axis_name_y = "Countries",
                       axis_name_x = "Time",
                       alpha_color = 0.9)

# Example 2: "highBest" type of indicator:
# Graphical plot of sigma convergence for the emp_20_64_MS Eurofound dataset:
data(emp_20_64_MS)
mySC <- sigma_conv(emp_20_64_MS)
resDMeur <- departure_mean(oriTB = emp_20_64_MS, sigmaTB = mySC$res)
myG1 <- NULL
myG1 <- graph_departure(resDMeur$res$departures,
                        timeName = "time",
                        indiType = "highBest",
                        displace = 0.25,
                        displaceh = 0.45,
                        dimeFontNum = 6,
                        myfont_scale = 1.35,
                        x_angle = 45,
                        axis_name_y = "Countries",
                        axis_name_x = "Time",
                        alpha_color = 0.9)

# Plot mean departures for selected countries only and change the colour of rectangles:
myG2 <- NULL
myG2 <- graph_departure(resDMeur$res$departures[,1:8],
                        timeName = "time",
                        indiType = "highBest",
                        displace = 0.25,
                        displaceh = 0.45,
                        dimeFontNum = 6,
                        myfont_scale = 1.35,
                        x_angle = 45,
                        color_rect = c("-1"='red', "0"='yellow',"1"='green4'),
                        axis_name_y = "Countries",
                        axis_name_x = "Time",
                        alpha_color = 0.9)
}
}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
