% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_pattern_ori.R
\name{ms_pattern_ori}
\alias{ms_pattern_ori}
\title{Find patterns for all countries}
\usage{
ms_pattern_ori(myTB, timeName = "time", typeIn = c("highBest", "lowBest")[1])
}
\arguments{
\item{myTB}{a dataset (tibble) for an indicator, time by countries.
The first and last time are respectively the first
and last rows of the dataset,
which must be  time sorted.}

\item{timeName}{a string with name of the time variable}

\item{typeIn}{the type of indicator considered 'highBest' (default)
or 'lowBest'}
}
\value{
the type of pattern
}
\description{
The input is a time by countries dataset where all countries contributing
to the average must be present.
Indicators of type 'low is better' are transformed
(highestRef - Y), thus the distance from the maximum value
for each original observation is calculated.
}
\details{
This is the reference implementation as described  by the Eurofound  report
"Monitoring convergence in the European Union
Upward convergence in the EU: Concepts, measurements and indicators", 2018.
}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
