% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{diagnose_data}
\alias{diagnose_data}
\title{Diagnose and prepare data matrices}
\usage{
diagnose_data(X_matrix, Y_matrix, verbose = TRUE)
}
\arguments{
\item{X_matrix}{Numeric matrix or data frame of X variables (e.g., Marxist prices).}

\item{Y_matrix}{Numeric matrix or data frame of Y variables (e.g., market prices/CPI).}

\item{verbose}{Logical; print diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{X_matrix}}{Cleaned and prepared X matrix.}
\item{\code{Y_matrix}}{Cleaned and prepared Y matrix.}
}
}
\description{
Performs data validation, missing value imputation, and variance checks on
input matrices to prepare them for factor analysis. Handles dimension
compatibility, NA values, and zero-variance columns.
}
\details{
The function:
\itemize{
\item Converts to matrix format if needed
\item Validates dimensional compatibility
\item Imputes missing values via interpolation (using zoo if available)
\item Adds minimal noise to zero-variance columns
\item Reports diagnostic information
}
}
