% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads.R
\name{topic_sim_dyads}
\alias{topic_sim_dyads}
\title{Calculate topic similarity for multiple dyads}
\usage{
topic_sim_dyads(conversations, method = "lda", num_topics = 2, window_size = 3)
}
\arguments{
\item{conversations}{A data frame with columns 'dyad_id', 'speaker', and 'processed_text'}

\item{method}{A character string specifying the method to use: currently only "lda" is supported}

\item{num_topics}{An integer specifying the number of topics to use in the LDA model}

\item{window_size}{An integer specifying the size of the sliding window}
}
\value{
A list containing the sequence of similarities for each dyad and the overall average similarity
}
\description{
This function calculates topic similarity over a sequence of conversation exchanges for multiple dyads.
It uses the Latent Dirichlet Allocation (LDA) method for topic modeling and the "slam" package for
efficient handling of sparse matrices.
}
\examples{
convs <- data.frame(
  dyad_id = c(1, 1, 1, 1, 2, 2, 2, 2),
  speaker = c("A", "B", "A", "B", "C", "D", "C", "D"),
  processed_text = c("i love pizza", "me too favorite food",
                     "whats your favorite topping", "enjoy pepperoni mushrooms",
                     "i prefer pasta", "pasta delicious like spaghetti carbonara",
                     "ever tried making home", "yes quite easy make")
)
topic_sim_dyads(convs, method = "lda", num_topics = 2, window_size = 2)
}
