% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_copernicus.R
\name{copernicus_set_env_credentials}
\alias{copernicus_set_env_credentials}
\title{Set Copernicus Marine credentials in environment file}
\usage{
copernicus_set_env_credentials(username, password, overwrite = FALSE)
}
\arguments{
\item{username}{Character. Copernicus Marine username.}

\item{password}{Character. Copernicus Marine password.}

\item{overwrite}{Logical. Overwrite existing credentials in .Renviron? Default: FALSE.}
}
\value{
Invisible TRUE if successful.
}
\description{
Helper function to set credentials in .Renviron file for persistent storage.
This is more secure than storing in scripts.
}
\examples{
\dontrun{
# Set credentials in .Renviron (will persist across R sessions)
copernicus_set_env_credentials("your_username", "your_password")
}
}
