/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data.simple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.corehunter.data.DefaultGenotypeData;
import org.corehunter.data.FrequencyGenotypeData;
import org.corehunter.data.simple.SimpleFrequencyGenotypeData;
import org.jamesframework.core.subset.SubsetSolution;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.RowWriter;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class SimpleDefaultGenotypeData
extends SimpleFrequencyGenotypeData
implements DefaultGenotypeData {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "X";
    private static final String NAMES_HEADER = "NAME";
    private static final String IDENTIFIERS_HEADER = "ID";
    private static final String SELECTED_HEADER = "SELECTED";
    private final String[][][] observedAlleles;

    public SimpleDefaultGenotypeData(SimpleEntity[] itemHeaders, String[] markerNames, String[][][] observedAlleles) {
        this("Default marker data", itemHeaders, markerNames, observedAlleles);
    }

    public SimpleDefaultGenotypeData(String datasetName, SimpleEntity[] itemHeaders, String[] markerNames, String[][][] observedAlleles) {
        this(datasetName, itemHeaders, markerNames, SimpleDefaultGenotypeData.inferAlleleNames(observedAlleles), observedAlleles);
    }

    private SimpleDefaultGenotypeData(String datasetName, SimpleEntity[] itemHeaders, String[] markerNames, String[][] alleleNames, String[][][] observedAlleles) {
        super(datasetName, itemHeaders, markerNames, alleleNames, SimpleDefaultGenotypeData.inferAlleleFrequencies(observedAlleles, alleleNames));
        int numGeno = observedAlleles.length;
        int numMark = alleleNames.length;
        if (numGeno == 0) {
            throw new IllegalArgumentException("No data (zero rows).");
        }
        this.observedAlleles = new String[numGeno][][];
        int[] colsPerMarker = IntStream.generate(() -> -1).limit(numMark).toArray();
        for (int i = 0; i < numGeno; ++i) {
            String[][] geno = observedAlleles[i];
            if (geno == null) {
                throw new IllegalArgumentException(String.format("Marker data not defined for item %d.", i));
            }
            if (numMark == -1) {
                numMark = geno.length;
                if (numMark == 0) {
                    throw new IllegalArgumentException(String.format("No markers (zero columns) for item %d.", i));
                }
            } else if (geno.length != numMark) {
                throw new IllegalArgumentException(String.format("Incorrect number of markers for item %d. Expected: %d, actual: %d.", i, numMark, geno.length));
            }
            this.observedAlleles[i] = new String[numMark][];
            for (int m = 0; m < numMark; ++m) {
                String[] alleleObs = geno[m];
                if (alleleObs == null) {
                    throw new IllegalArgumentException(String.format("Observed alleles not defined for item %d at marker %d.", i, m));
                }
                if (colsPerMarker[m] == -1) {
                    colsPerMarker[m] = alleleObs.length;
                    if (colsPerMarker[m] == 0) {
                        throw new IllegalArgumentException(String.format("No allele references (zero columns) for item %d at marker %d.", i, m));
                    }
                } else if (alleleObs.length != colsPerMarker[m]) {
                    throw new IllegalArgumentException(String.format("Incorrect number of columns for item %d at marker %d. Expected: %d, actual: %d.", i, m, colsPerMarker[m], alleleObs.length));
                }
                this.observedAlleles[i][m] = Arrays.copyOf(alleleObs, colsPerMarker[m]);
            }
        }
    }

    private static String[][] inferAlleleNames(String[][][] observedAlleles) {
        int n = observedAlleles.length;
        int numMarkers = observedAlleles[0].length;
        String[][] alleleNames = new String[numMarkers][];
        for (int m = 0; m < numMarkers; ++m) {
            TreeSet<String> alleles = new TreeSet<String>();
            for (int i = 0; i < n; ++i) {
                for (String observed : observedAlleles[i][m]) {
                    if (observed == null) continue;
                    alleles.add(observed);
                }
            }
            if (alleles.isEmpty()) {
                throw new IllegalArgumentException(String.format("No data for marker %d.", m));
            }
            alleleNames[m] = alleles.toArray(new String[alleles.size()]);
        }
        return alleleNames;
    }

    private static double[][][] inferAlleleFrequencies(String[][][] observedAlleles, String[][] alleleNames) {
        int n = observedAlleles.length;
        int numMarkers = observedAlleles[0].length;
        double[][][] alleleFreqs = new double[n][numMarkers][];
        for (int m = 0; m < numMarkers; ++m) {
            String[] markerAlleleNames = alleleNames[m];
            int numMarkerAlleles = markerAlleleNames.length;
            HashMap<String, Integer> markerAlleleIndices = new HashMap<String, Integer>();
            for (int a = 0; a < numMarkerAlleles; ++a) {
                markerAlleleIndices.put(markerAlleleNames[a], a);
            }
            for (int i = 0; i < n; ++i) {
                String[] observed = observedAlleles[i][m];
                double[] freqs = new double[numMarkerAlleles];
                if (Arrays.stream(observed).noneMatch(Objects::isNull)) {
                    Arrays.fill(freqs, 0.0);
                } else {
                    Arrays.fill(freqs, Double.NaN);
                }
                double incr = 1.0 / (double)observed.length;
                Arrays.stream(observed).filter(Objects::nonNull).forEach(observedAllele -> SimpleDefaultGenotypeData.increaseFrequency(freqs, (Integer)markerAlleleIndices.get(observedAllele), incr));
                alleleFreqs[i][m] = freqs;
            }
        }
        return alleleFreqs;
    }

    private static void increaseFrequency(double[] freqs, int a, double incr) {
        freqs[a] = Double.isNaN(freqs[a]) ? incr : freqs[a] + incr;
    }

    @Override
    public int getNumberOfObservedAllelesPerIndividual(int markerIndex) {
        return this.observedAlleles[0][markerIndex].length;
    }

    @Override
    public String getObservedAllele(int id, int markerIndex, int i) {
        return this.observedAlleles[id][markerIndex][i];
    }

    public static FrequencyGenotypeData readData(Path filePath, FileType type) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        Throwable throwable = null;
        try (RowReader reader = IOUtilities.createRowReader(filePath, type, 16, 32);){
            LinkedHashMap<String, Integer> markers;
            int n;
            if (reader == null || !reader.ready()) {
                throw new IOException("Can not create reader for file " + filePath + ". File may be empty.");
            }
            if (!reader.hasNextRow()) {
                throw new IOException("File is empty.");
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (reader.nextRow()) {
                rows.add(reader.getRowCellsAsStringArray());
            }
            if (rows.isEmpty()) {
                throw new IOException("File is empty.");
            }
            int numCols = rows.stream().mapToInt(row -> ((String[])row).length).max().getAsInt();
            for (int r = 0; r < rows.size(); ++r) {
                String[] row2 = (String[])rows.get(r);
                if (row2.length < numCols) {
                    row2 = Arrays.copyOf(row2, numCols);
                }
                rows.set(r, row2);
            }
            if (numCols < 1 || !Objects.equals(((String[])rows.get(0))[0], IDENTIFIERS_HEADER)) {
                throw new IOException("Missing header row/column ID.");
            }
            boolean withNames = numCols >= 2 && Objects.equals(((String[])rows.get(0))[1], NAMES_HEADER);
            int numHeaderCols = 1;
            if (withNames) {
                ++numHeaderCols;
            }
            if ((n = rows.size() - 1) == 0) {
                throw new IOException("No data rows.");
            }
            int numDataCols = numCols - numHeaderCols;
            if (numDataCols == 0) {
                throw new IOException("No data columns.");
            }
            String[] headerRow = (String[])rows.get(0);
            String[] dataColumnNames = Arrays.copyOfRange(headerRow, numHeaderCols, numCols);
            try {
                markers = SimpleDefaultGenotypeData.inferMarkerNames(dataColumnNames);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex);
            }
            int numMarkers = markers.size();
            String[] markerNames = ((HashMap)markers).keySet().toArray(new String[0]);
            Integer[] markerNumCols = ((HashMap)markers).values().toArray(new Integer[0]);
            String[] itemNames = new String[n];
            String[] itemIdentifiers = new String[n];
            for (int i = 0; i < n; ++i) {
                String[] row3 = (String[])rows.get(i + 1);
                itemIdentifiers[i] = row3[0];
                itemNames[i] = withNames ? row3[1] : itemIdentifiers[i];
            }
            String[][][] observedAlleles = new String[n][numMarkers][];
            for (int i = 0; i < n; ++i) {
                String[] row4 = (String[])rows.get(i + 1);
                int c = numHeaderCols;
                for (int m = 0; m < numMarkers; ++m) {
                    int nCol = markerNumCols[m];
                    observedAlleles[i][m] = new String[nCol];
                    for (int mc = 0; mc < nCol; ++mc) {
                        observedAlleles[i][m][mc] = row4[c++];
                    }
                }
            }
            SimpleEntity[] headers = new SimpleEntity[n];
            for (int i = 0; i < n; ++i) {
                String identifier = itemIdentifiers[i];
                String name = withNames ? itemNames[i] : itemIdentifiers[i];
                headers[i] = name != null ? new SimpleEntityPojo(identifier, name) : new SimpleEntityPojo(identifier);
            }
            try {
                SimpleDefaultGenotypeData i = new SimpleDefaultGenotypeData(filePath.getFileName().toString(), headers, markerNames, observedAlleles);
                return i;
            }
            catch (IllegalArgumentException ex) {
                try {
                    throw new IOException(ex);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void writeData(Path filePath, FileType fileType, SubsetSolution solution, boolean includeSelected, boolean includeUnselected, boolean includeIndex) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (filePath.toFile().exists()) {
            throw new IOException("File already exists: " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        if (solution == null) {
            throw new NullPointerException("Solution must be defined");
        }
        if (!solution.getAllIDs().equals(this.getIDs())) {
            throw new IllegalArgumentException("Solution ids must match data.");
        }
        if (!includeSelected && !includeUnselected) {
            throw new IllegalArgumentException("At least one of 'includeSelected' or 'includeUnselected' must be used.");
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        boolean markSelection = includeSelected && includeUnselected;
        try (RowWriter writer = IOUtilities.createRowWriter(filePath, fileType, 3);){
            Set<Integer> includedIDs;
            if (writer == null || !writer.ready()) {
                throw new IOException("Can not create writer for file " + filePath + ".");
            }
            if (includeIndex) {
                writer.writeCell(ID_HEADER);
                writer.newColumn();
            }
            writer.writeCell(IDENTIFIERS_HEADER);
            writer.newColumn();
            writer.writeCell(NAMES_HEADER);
            if (markSelection) {
                writer.newColumn();
                writer.writeCell(SELECTED_HEADER);
            }
            for (int m = 0; m < this.getNumberOfMarkers(); ++m) {
                for (int c = 0; c < this.getNumberOfObservedAllelesPerIndividual(m); ++c) {
                    writer.newColumn();
                    writer.writeCell(this.getMarkerName(m));
                }
            }
            if (markSelection) {
                includedIDs = this.getIDs();
            } else if (includeSelected) {
                includedIDs = solution.getSelectedIDs();
            } else if (includeUnselected) {
                includedIDs = solution.getUnselectedIDs();
            } else {
                throw new IllegalArgumentException("At least one of 'includeSelected' or 'includeUnselected' must be used.");
            }
            ArrayList<Integer> sortedIDs = new ArrayList<Integer>(includedIDs);
            sortedIDs.sort(null);
            Set<Integer> selected = solution.getSelectedIDs();
            Iterator iterator = sortedIDs.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                writer.newRow();
                if (includeIndex) {
                    writer.writeCell(id);
                    writer.newColumn();
                }
                SimpleEntity header = this.getHeader(id);
                writer.writeCell(header.getUniqueIdentifier());
                writer.newColumn();
                writer.writeCell(header.getName());
                if (markSelection) {
                    writer.newColumn();
                    writer.writeCell(selected.contains(id));
                }
                for (int c = 0; c < this.observedAlleles[id].length; ++c) {
                    writer.newColumn();
                    writer.writeRowCellsAsArray(this.observedAlleles[id][c]);
                }
            }
            writer.close();
        }
    }
}

