% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrChord.R
\name{corrChord}
\alias{corrChord}
\title{corrChord}
\usage{
corrChord(mat, threshold = 0, circle = FALSE)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{threshold}{A numeric value indicating the minimum absolute
correlation value to display in the plot.}

\item{circle}{A logical value indicating whether to use a circular
layout (TRUE) or linear layout (FALSE), default is FALSE.}
}
\value{
A chord plot displaying correlations.
}
\description{
This function creates a chord plot of correlations between variables in a dataset.
}
\details{
When using a large amount of data, this plot can quickly become over
complicated. It is recommended to filter the correlations using the \code{threshold}
argument to simplify the visualisation.
}
\examples{
cm <- cor(mtcars)

corrChord(mat = cm,
          threshold = 0.8)

corrChord(mat = cm,
          threshold = 0.8,
          circle = TRUE)

}
