% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrGrid.R
\name{corrGrid}
\alias{corrGrid}
\title{Plot a correlation grid}
\usage{
corrGrid(
  mat,
  display = c("all", "upper", "lower"),
  type = c("square", "circle", "text", "pie"),
  showDiag = "TRUE",
  pal = colorRampPalette(c("darkblue", "white", "darkred"))(100)
)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{display}{A character string, specifying the display type,
one of "all", "upper", or "lower" (default: "all").}

\item{type}{A character string, specifying the shape of the correlation
coefficients, one of "square", "circle", or "text" (default: "square").}

\item{showDiag}{A logical value, if TRUE (default), the diagonal of the
correlation matrix is shown.}

\item{pal}{A color palette function, used for the correlation
coefficient colors.}
}
\value{
A correlation grid plot
}
\description{
Create a correlation grid plot to visualize correlations among the columns of a dataset
}
\examples{
cm <- cor(mtcars)
corr_grid_plot <- corrGrid(mat = cm,
                           type = 'square')
}
