% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2long.R
\name{matrix2long}
\alias{matrix2long}
\title{matrix2long}
\usage{
matrix2long(mat)
}
\arguments{
\item{mat}{A matrix to be converted into long format.}
}
\value{
A data frame in long format with columns: row, column, value, and id.
}
\description{
Convert a Matrix to Long Format.
}
\details{
This function converts a matrix into a long format data frame.
The resulting data frame contains four columns: row, column, value, and id. The 'id' column
assigns a unique identifier to each column group, making it easier to identify and analyze
the data by column groups.
}
\examples{
# Create a matrix
mat <- matrix(data = 1:9,
              nrow = 3,
              ncol = 3,
              dimnames = list(c("A", "B", "C"),
                              c("X", "Y", "Z")))

long_format <- matrix2long(mat)
long_format

# Using correlation matrix
matrix2long(cor(mtcars))

}
