% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrPrune.R
\name{corrPrune}
\alias{corrPrune}
\title{Association-Based Predictor Pruning}
\usage{
corrPrune(
  data,
  threshold = 0.7,
  measure = "auto",
  mode = "auto",
  force_in = NULL,
  by = NULL,
  group_q = 1,
  max_exact_p = 100,
  ...
)
}
\arguments{
\item{data}{A data.frame containing candidate predictors.}

\item{threshold}{Numeric scalar. Maximum allowed pairwise association
(default: 0.7). Must be non-negative.}

\item{measure}{Character string specifying the association measure to use.
Options: \code{"auto"} (default), \code{"pearson"}, \code{"spearman"}, \code{"kendall"},
\code{"cramersv"}, \code{"eta"}, etc. When \code{"auto"}, Pearson correlation is used
for all-numeric data, and appropriate measures are selected for mixed-type
data.}

\item{mode}{Character string specifying the search algorithm. Options:
\itemize{
\item \code{"auto"} (default): uses exact search if number of predictors <= \code{max_exact_p},
otherwise uses greedy search
\item \code{"exact"}: exhaustive search for maximal subsets (may be slow for large p)
\item \code{"greedy"}: fast approximate search using iterative removal
}}

\item{force_in}{Character vector of variable names that must be retained in
the final subset. Default: NULL.}

\item{by}{Character vector naming one or more grouping variables. If provided,
associations are computed separately within each group, then aggregated
using the quantile specified by \code{group_q}. Default: NULL (no grouping).}

\item{group_q}{Numeric scalar in (0, 1]. Quantile used to aggregate
associations across groups when \code{by} is provided. Default: 1 (maximum,
ensuring threshold holds in all groups). Use 0.9 for 90th percentile, etc.}

\item{max_exact_p}{Integer. Maximum number of predictors for which exact
mode is used when \code{mode = "auto"}. Default: 100.}

\item{...}{Additional arguments (reserved for future use).}
}
\value{
A data.frame containing the pruned subset of predictors. The result
has the following attributes:
\describe{
\item{selected_vars}{Character vector of retained variable names}
\item{removed_vars}{Character vector of removed variable names}
\item{mode}{Character string indicating which mode was used ("exact" or "greedy")}
\item{measure}{Character string indicating which association measure was used}
\item{threshold}{The threshold value used}
}
}
\description{
\code{corrPrune()} performs model-free variable subset selection by iteratively
removing predictors until all pairwise associations fall below a specified
threshold. It returns a single pruned data frame with predictors that satisfy
the association constraint.
}
\details{
\code{corrPrune()} identifies a subset of predictors whose pairwise associations
are all below \code{threshold}. The function works in several stages:
\enumerate{
\item \strong{Variable type detection}: Identifies numeric vs. categorical predictors
\item \strong{Association measurement}: Computes appropriate pairwise associations
\item \strong{Grouping (optional)}: If \code{by} is specified, computes associations within
each group and aggregates using the specified quantile
\item \strong{Feasibility check}: Verifies that \code{force_in} variables satisfy the
threshold constraint
\item \strong{Subset selection}: Uses either exact or greedy search to find a valid subset
}

\strong{Grouped Pruning}: When \code{by} is provided, the function ensures the selected
predictors satisfy the threshold constraint across groups. For example, with
\code{group_q = 1} (default), the returned predictors will have pairwise associations
below \code{threshold} in \emph{all} groups. With \code{group_q = 0.9}, they will satisfy
the constraint in at least 90\% of groups.

\strong{Mode Selection}: Exact mode guarantees finding all maximal subsets and
returns the largest one. Greedy mode is faster but approximate, using an
iterative removal strategy based on association scores.

\strong{Tie-Breaking}: When multiple subsets or variables are equally good,
deterministic tie-breaking is applied:
\itemize{
\item \strong{Exact mode}: Selects by (1) largest subset size, (2) lowest
average correlation, (3) alphabetically first variable names. Column
order does not affect the result.
\item \strong{Greedy mode}: Removes the variable with (1) most constraint
violations, (2) highest max association, (3) highest average association,
(4) lowest column index. Column order can influence the result when
earlier criteria are tied.
}
To see all maximal subsets instead of a single selection, use
\code{\link{corrSelect}()}.
}
\examples{
# Basic numeric data pruning
data(mtcars)
pruned <- corrPrune(mtcars, threshold = 0.7)
names(pruned)

# Force certain variables to be included
pruned <- corrPrune(mtcars, threshold = 0.7, force_in = "mpg")

# Use greedy mode for faster computation
pruned <- corrPrune(mtcars, threshold = 0.7, mode = "greedy")

}
\seealso{
\code{\link{corrSelect}} for exhaustive subset enumeration,
\code{\link{assocSelect}} for mixed-type data subset enumeration,
\code{\link{modelPrune}} for model-based predictor pruning.
}
