% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_matrix_random_block.R
\name{augment_matrix_random_block}
\alias{augment_matrix_random_block}
\title{Augment Matrix with Random 2x2 Block Adjustment}
\usage{
augment_matrix_random_block(table, delta)
}
\arguments{
\item{table}{A matrix (numeric) to which the random block adjustment will be applied.}

\item{delta}{A numeric value that determines the magnitude of the adjustment.
If positive, values are subtracted from the block; if negative, values are added.}
}
\value{
A matrix (numeric) with the adjusted 2x2 block.
}
\description{
This function selects a random 2x2 block of values in the input matrix \code{table} and modifies them
based on the specified delta. It checks certain conditions before applying the modifications to
the selected block. The process repeats until a valid block is found or a maximum of 100 iterations
is reached.
}
\examples{
table <- matrix(1:9, 3, 3)
augment_matrix_random_block(table, 1)

}
