% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_gaussian_copula_samples.R
\name{generate_gaussian_copula_samples}
\alias{generate_gaussian_copula_samples}
\title{Generate Gaussian Copula Samples}
\usage{
generate_gaussian_copula_samples(n, d, rho_matrix)
}
\arguments{
\item{n}{Integer. The number of samples to generate.}

\item{d}{Integer. The dimensionality of the copula.}

\item{rho_matrix}{A \code{d x d} positive-definite correlation matrix.}
}
\value{
A matrix of size \code{n x d}, where each row represents a sample
and each column corresponds to a dimension. The values are uniformly
distributed in \code{[0, 1]}.
}
\description{
This function generates samples from a Gaussian copula given a specified
correlation matrix. The samples are uniformly distributed in \code{[0, 1]} across
dimensions.
}
\details{
The function works as follows:
\enumerate{
\item Generates multivariate normal samples with the given correlation matrix.
\item Transforms the samples to the uniform distribution \code{[0, 1]} using the
cumulative distribution function (CDF) of the standard normal.
}
}
\examples{
# Example usage:
library(MASS)  # Load package for `mvrnorm`
rho_matrix <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)  # 2x2 correlation matrix
samples <- generate_gaussian_copula_samples(n = 1000, d = 2, rho_matrix = rho_matrix)
head(samples)

}
