% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covercorr_internal.R
\name{MK_rank}
\alias{MK_rank}
\title{Monge–Kantorovich ranks (uniform OT via squared distances)}
\usage{
MK_rank(X, U)
}
\arguments{
\item{X}{Numeric vector of length \eqn{n}, or numeric matrix with \eqn{n}
rows and \eqn{d} columns. If not a matrix, it is coerced with
\code{as.matrix()}.}

\item{U}{Numeric vector of length \eqn{n}, or numeric matrix with \eqn{n}
rows and \eqn{d} columns. If not a matrix, it is coerced with
\code{as.matrix()}. Must have the same number of rows as \code{X}.}
}
\value{
If \code{ncol(X) == 1}, a numeric vector of length \eqn{n}
containing the entries of \code{U} reordered to match the ranks of
\code{X}. Otherwise, a numeric \eqn{n \times d} matrix whose \eqn{i}-th row
is the matched row of \code{U} corresponding to the \eqn{i}-th row of
\code{X}.
}
\description{
Computes the optimal matching that maps each observation in \code{X} to a
reference point in \code{U} using uniform weights and squared Euclidean cost.
Internally uses \code{transport::transport(method = "networkflow", p = 2)}.
In 1D, this reduces to a rank-based matching
\code{sort(U)[rank(X, ties.method = "random")]}.
}
\details{
\itemize{
\item Rows must match: \code{nrow(X) == nrow(U)} (otherwise an error is thrown).
\item Columns must match: \code{ncol(X) == ncol(U)} (otherwise an error is thrown).
\item Weights are uniform (\eqn{1/n}) and the cost matrix is the sum of squared
coordinate differences across columns.
\item In 1D, ties in \code{X} are broken at random via
\code{ties.method = "random"}; use \code{set.seed()} for reproducibility.
}
}
\section{Dependencies}{

Requires the \pkg{transport} package.
}

\examples{
# 1D example (set seed for reproducible tie-breaking)
set.seed(1)
x <- rnorm(10)
u <- seq(0, 1, length.out = 10)
MK_rank(x, u)

# 2D example
set.seed(42)
X <- matrix(rnorm(200), ncol = 2)   # 100 x 2
U <- matrix(runif(200),  ncol = 2)  # 100 x 2
R <- MK_rank(X, U)
dim(R)  # 100 2

}
