% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cpm}
\alias{summary.cpm}
\alias{print.cpm_summary}
\title{Summary of a cpm object.}
\usage{
\method{summary}{cpm}(object, ..., method = c("pearson", "spearman"), edge_level = 0.5)

\method{print}{cpm_summary}(x, ...)
}
\arguments{
\item{object}{An object of class \code{cpm}.}

\item{...}{Other parameters passed to the function.}

\item{method}{A character vector indicating the method used to calculate the
correlation between the real and predicted values.}

\item{edge_level}{A numeric value between 0 and 1 indicating the proportional
threshold for edge selection.}

\item{x}{An object of class \code{cpm_summary}.}
}
\value{
A list of class \code{cpm_summary} containing two elements:
\item{performance}{A matrix of prediction performance, including the
correlation between the real and predicted values for both edges,
positive edges only, and negative edges only.}

\item{edges}{A logical vector indicating whether each edge is selected
based on the edge_level.}

\item{params}{A list of parameters used in the summary.}
}
\description{
This function provides a summary of a \code{cpm} object, including the
prediction performance and the selected edges.
}
