% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assign}
\alias{assign}
\alias{assign,CppVector-method}
\alias{assign,CppDeque-method}
\alias{assign,CppForwardList-method}
\alias{assign,CppList-method}
\title{Replace all elements}
\usage{
assign(x, value, pos, envir, inherits, immediate)
}
\arguments{
\item{x}{A CppVector, CppDeque, CppForwardList, or CppList object.}

\item{value}{A vector. It is called \code{value} instead of \code{values} for compliance with the generic \code{base::assign} method.}

\item{pos}{Ignored.}

\item{envir}{Ignored.}

\item{inherits}{Ignored.}

\item{immediate}{Ignored.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Replace all elements in a container by reference.
}
\details{
Replaces all elements in \code{x} with the elements in \code{value}.

The parameters \code{pos}, \code{envir}, \code{inherits}, and \code{immediate} are only included for compatibility with the generic \code{base::assign} 
method and have no effect.
}
\examples{
v <- cpp_vector(4:9)
v
# 4 5 6 7 8 9

assign(v, 12:14)
v
# 12 13 14

}
\seealso{
\link{emplace}, \link{emplace_after}, \link{emplace_back}, \link{emplace_front}, \link{insert}, \link{insert_after}, \link{insert_or_assign}.
}
