% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newknots.R
\name{newknots}
\alias{newknots}
\title{New Knots for CPs and CNs in CPR and CNR}
\usage{
newknots(form, nk)
}
\arguments{
\item{form}{a \code{formula}}

\item{nk}{numeric vector, or a list of numeric vectors, to be used in a
\code{\link{bsplines}} or \code{\link{btensor}} call, respectively.}
}
\value{
Expected use is within the \code{cpr} and \code{cnr} calls.  The
return object a formula to define a control polygon/net
with different knots than then ones found within \code{form}.
}
\description{
Non-exported function, \code{newknots} are used in the \code{\link{cpr}} and
\code{\link{cnr}} calls.  Used to create a new control polygon or control net
from with different internal knots.
}
\details{
Think of this function as an analogue to the \code{\link{stats}{update}}
calls.  Where \code{\link{stats}{update}} will modify a \code{call}, the
\code{newknots} will update just the \code{iknots} argument of a
\code{bsplines} or \code{btensor} call within the \code{formula} argument of
a \code{\link{cp}} or \code{\link{cn}} call.
}
\examples{

cp0 <- cp(log(pdg) ~ bsplines(day, iknots = c(-.25, 0, 0.25), bknots = c(-1, 1)), data = spdg)

new_knots <- c(-0.85, 0, 0.25, 0.3)
f <- cpr:::newknots(cp0$call$formula, nk = new_knots)
f
cp(f, data = spdg)

}
\seealso{
\code{\link{update_bsplines}} for a more generic tool for the end
user.
}
