% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_markit.R
\name{download_markit}
\alias{download_markit}
\title{Get rates from Markit}
\usage{
download_markit(start, end, currency = "USD")
}
\arguments{
\item{start}{date for gathering interest rates. Must be a Date type}

\item{end}{date for gathering interest rates. Must be a Date type}

\item{currency}{for which rates are being retrieved}
}
\value{
data frame containing the rates from every day from start to end 
  dates. Note: the date in the output data frame does not refer to the rates 
  of that day but to the date on which the CDS is being priced. So the 
  corresponding rate is actually the rate of the previous day. Example: if 
  the column reads 2014-04-22, the corresponding rates are actually for 
  2014-04-21.
}
\description{
\code{download_markit} takes a data frame of dates and returns a data frame 
with the yields for different maturities.
}
\examples{
\dontrun{
download_markit(start = as.Date("2005-12-31"), end = as.Date("2006-01-04"), 
                currency = "JPY")
}       
}
\seealso{
\code{\link{download_FRED}} \code{\link{build_rates}}
}
