% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implied_RR.R
\name{implied_RR}
\alias{implied_RR}
\title{Calculates Implied Recovery Rate}
\usage{
implied_RR(
  x,
  date.var = "date",
  tenor.var = "tenor",
  maturity.var = "maturity",
  spread.var = "spread",
  pd.var = "pd"
)
}
\arguments{
\item{x}{data frame, contains all the relevant columns.}

\item{date.var}{character, column in x containing date variable.}

\item{tenor.var}{character, column in x containing tenors.}

\item{maturity.var}{character, column in x containing maturity date.}

\item{spread.var}{character, column in x containing spread in basis points.}

\item{pd.var}{name of the column containing the probability of default rates.}
}
\value{
implied recovery rate in percentage based on the general 
  approximation for a probability of default in the Bloomberg manual. The 
  actual calculation uses a complicated bootstrapping process, so the results
  may be marginally different.
}
\description{
\code{implied_RR} that calculates the recovery rate implied by the CDS spread
and probability of default (pd) by using the ISDA model. This takes a data 
frame of inputs and returns a vector of the same length.
}
