% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_relation.R
\name{sch_add_relations_tibble}
\alias{sch_add_relations_tibble}
\title{Add Relations Tibble}
\usage{
sch_add_relations_tibble(sch, rtb)
}
\arguments{
\item{sch}{A schedule object.}

\item{rtb}{A tibble or data frame with relations definitions.}
}
\value{
A Schedule object with a relation added.
}
\description{
Add relations tibble to a schedule.
}
\examples{
atb <- tibble::tibble(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1L,2L,2L,4L,3L,3L,3L,2L,1L,1L,2L,1L,1L,1L,1L,2L,1L)
)
rtb <- data.frame(
  from = c(1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L,  3L,  4L,  5L,  6L,
           7L,  8L,  9L, 10L, 11L, 11L, 12L, 12L, 13L, 13L, 14L, 14L, 15L, 15L),
  to   = c(2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 11L, 11L,
           12L, 13L, 14L, 15L, 16L, 17L, 16L, 17L, 16L, 17L, 16L, 17L, 16L, 17L)
)
sch <- sch_new() \%>\%
  sch_add_activities_tibble(atb) \%>\%
  sch_add_relations_tibble(rtb) \%>\%
  sch_plan()
sch_duration(sch) # 11

}
