% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crcal.R
\name{xrdplot}
\alias{xrdplot}
\title{Plots the Crystalline Area of a X-Ray Diffraction Pattern of Starch}
\usage{
xrdplot(pattern, background)
}
\arguments{
\item{pattern}{matrix. The matrix of X-ray diffraction pattern.  The first row corresponds to Bragg angle 2\eqn{\theta}; the second row corresponds to intensity.}

\item{background}{matrix. The matrix of background shape (curve of the amorphous starch). The first row corresponds to Bragg angle 2\eqn{\theta}; the second row corresponds to intensity.}
}
\description{
Produces a graph of the crystalline area of a X-ray diffraction pattern of starch and background.
}
\examples{
# Convert data frame to matrix, select A-type starch
pattern <- as.matrix(t(XRD[, c("Bragg_angle","A")]))
# List of crystallinity components
crs <- crystMW(pattern, N = 11, iter = 100)
# Original matrix
original <- crs$original
# Background shape
background <- crs$background
# Plots the crystalline area of a XRD pattern
xrdplot(pattern=original, background=background)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

