% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_utils.R
\name{irank}
\alias{irank}
\alias{frank}
\title{Compute ranks}
\usage{
irank(x, omega = 0, increasing = FALSE, na.rm = FALSE)

frank(x, omega = 0, increasing = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{vector of values to be ranked}

\item{omega}{numeric value in [0,1], defining how ties in \code{x} (if any) are handled; default is \code{0}. See Details.}

\item{increasing}{logical; if \code{FALSE} (default), then large elements in \code{x} receive a small rank. Otherwise, large elements in \code{x} receive a large rank.}

\item{na.rm}{logical; if \code{TRUE}, then \code{NA}'s are removed from \code{x}. Default: \code{FALSE}.}
}
\value{
Numeric vector of the same length as \code{x} containing the integer (for \code{irank}) or fractional (for \code{frank}) ranks.
}
\description{
Compute integer of fractional ranks with flexible handling of ties.
}
\details{
\code{irank} implements all possible definitions of ranks of the values in \code{x}. Different definitions of the ranks are chosen through combinations of the two arguments
\code{omega} and \code{increasing}. Suppose \code{x} is of length \eqn{p}. If \code{increasing=TRUE}, then the largest value in \code{x} receives the rank \eqn{p} and the smallest
the rank \eqn{1}. If \code{increasing=FALSE}, then the largest value in \code{x} receives the rank \eqn{1} and the smallest
the rank \eqn{p}.

The value of \code{omega} indicates how ties are handled. If there are no ties in \code{x}, then the value of \code{omega} does not affect the ranks and the only choice to be made is whether
the ranks should be increasing or decreasing with the values in \code{x}. When there are ties in \code{x}, however, then there are infinitely
many possible ranks that can be assigned to a tied value.

When \code{increasing=TRUE}, then \code{omega=0} leads to the smallest possible and \code{omega=1} to the largest possible rank of a tied value. Values of \code{omega} between
0 and 1 lead to values of the rank between the largest and smallest.

\code{frank} takes the ranking returned by \code{irank} and divides the result by \code{length(x)}. The result is a ranking with
ranks in the interval [0,1]. An important special case occurs for \code{increasing=TRUE} and \code{omega=1}: in this case, the rank
of the value \code{x[j]} is equal to the empirical cdf of \code{x} evaluated at \code{x[j]}.
}
\examples{
# simple example without ties:
x <- c(3,8,-4,10,2)
irank(x, increasing=TRUE)
irank(x, increasing=FALSE)

# since there are no ties, the value of omega has no impact:
irank(x, increasing=TRUE, omega=0)
irank(x, increasing=TRUE, omega=0.5)
irank(x, increasing=TRUE, omega=1)

# simple example with ties:
x <- c(3,4,7,7,10,11,15,15,15,15)
irank(x, increasing=TRUE, omega=0) # smallest possible ranks
irank(x, increasing=TRUE, omega=0.5) # mid-ranks
irank(x, increasing=TRUE, omega=1) # largest possible ranks

# simple example of fractional ranks without ties:
x <- c(3,8,-4,10,2)
frank(x, increasing=TRUE)
frank(x, increasing=FALSE)
}
